package ru.yandex.direct.intapi.entity.idm.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;


@JsonInclude(JsonInclude.Include.NON_NULL)
public class GetRolesResponse extends IdmSuccessResponse {

    private String nextUrl;
    private List<GetRolesResponseItem> roles;

    @JsonGetter("next-url")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getNextUrl() {
        return nextUrl;
    }

    public GetRolesResponse withNextUrl(String nextUrl) {
        this.nextUrl = nextUrl;
        return this;
    }

    @JsonGetter("roles")
    public List<GetRolesResponseItem> getRoles() {
        return roles;
    }

    public GetRolesResponse withRoles(List<GetRolesResponseItem> roles) {
        this.roles = roles;
        return this;
    }

}
