package ru.yandex.direct.intapi.entity.idm.model;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import one.util.streamex.EntryStream;

import ru.yandex.direct.dbutil.model.ClientId;

import static ru.yandex.direct.intapi.entity.idm.converter.IdmCommonNames.CLIENT_ID_SLUG;
import static ru.yandex.direct.intapi.entity.idm.converter.IdmCommonNames.PASSPORT_LOGIN;
import static ru.yandex.direct.intapi.entity.idm.converter.IdmCommonNames.ROLE_PATH_SEPARATOR;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class GetRolesResponseItem {
    private String path;
    private String domainLogin;
    private Integer groupId;
    private Map<String, String> fields;
    private String passportLogin;
    private Long clientId;
    private Long internalUid;
    private Long supportId;
    private String roleName;

    private GetRolesResponseItem() {
    }

    public static Builder getBuilder(String basePath, String roleName) {
        return new Builder(basePath, roleName);
    }

    @JsonProperty("path")
    public String getPath() {
        return path;
    }

    @JsonProperty("login")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getDomainLogin() {
        return domainLogin;
    }

    @JsonProperty("group")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Integer getGroupId() {
        return groupId;
    }

    @JsonProperty("fields")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Map<String, String> getFields() {
        return fields;
    }

    @JsonIgnore
    public String getPassportLogin() {
        return passportLogin;
    }

    @JsonIgnore
    public Long getClientId() {
        return clientId;
    }

    @JsonIgnore
    public Long getInternalUid() {
        return internalUid;
    }

    @JsonIgnore
    public Long getSupportId() {
        return supportId;
    }

    @JsonIgnore
    public String getRoleName() {
        return roleName;
    }

    public static class Builder {
        private String basePath;
        private String roleName;
        private String domainLogin;
        private String passportLogin;
        private Long internalUid;
        private Long supportId;
        private Integer groupId;
        private ClientId clientId;

        public Builder(String basePath, String roleName) {
            this.basePath = basePath;
            this.roleName = roleName;
        }

        public GetRolesResponseItem build() {
            GetRolesResponseItem item = new GetRolesResponseItem();
            item.roleName = roleName;
            item.path = ROLE_PATH_SEPARATOR + basePath + ROLE_PATH_SEPARATOR + roleName + ROLE_PATH_SEPARATOR;
            item.clientId = ifNotNull(clientId, ClientId::asLong);
            item.domainLogin = ifNotNull(domainLogin, String::toLowerCase);
            item.passportLogin = ifNotNull(passportLogin, String::toLowerCase);
            item.groupId = groupId;
            item.internalUid = internalUid;
            item.supportId = supportId;
            Map<String, String> localFields = EntryStream
                    .of(PASSPORT_LOGIN, ifNotNull(passportLogin, String::toLowerCase),
                            CLIENT_ID_SLUG, ifNotNull(clientId, Object::toString))
                    .nonNullValues()
                    .toImmutableMap();
            item.fields = (localFields.isEmpty()) ? null : localFields;
            return item;
        }

        public Builder withDomainLogin(String domainLogin) {
            this.domainLogin = domainLogin;
            return this;
        }

        public Builder withPassportLogin(String passportLogin) {
            this.passportLogin = passportLogin;
            return this;
        }

        public Builder withInternalUid(Long internalUid) {
            this.internalUid = internalUid;
            return this;
        }

        public Builder withSupportId(Long supportId) {
            this.supportId = supportId;
            return this;
        }

        public Builder withGroupId(Integer groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder withClientId(ClientId clientId) {
            this.clientId = clientId;
            return this;
        }
    }

}
