package ru.yandex.direct.intapi.entity.idm.model;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class IdmException extends RuntimeException {

    private String errorText;
    private IdmErrorType errorType;

    private IdmException(String errorText, IdmErrorType errorType) {
        super(errorText);
        populate(errorText, errorType);
    }

    private void populate(String errorText, IdmErrorType errorType) {
        this.errorText = errorText;
        this.errorType = errorType;
    }

    public static IdmException idmErrorException(String errorText) {
        return new IdmException(errorText, IdmErrorType.ERROR);
    }

    public static IdmException idmFatalException(String errorText) {
        return new IdmException(errorText, IdmErrorType.FATAL);
    }

    public String getErrorText() {
        return errorText;
    }

    public IdmErrorType getErrorType() {
        return errorType;
    }

    public enum IdmErrorType {
        ERROR,
        FATAL
    }
}
