package ru.yandex.direct.intapi.entity.idm.model;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

import javax.annotation.Nullable;

/**
 * роли, которыми можно управлять через idm
 */
public enum IdmRole {
    SUPER("super", "супер-пользователь"),

    SUPERREADER("superreader", "суперсмотритель"),

    SUPPORT("support", "саппорт"),

    PLACER("placer", "вешальщик"),

    MEDIA("media", "медиапланер"),

    MANAGER("manager", "менеджер"),

    TEAMLEADER("teamleader", "тимлидер"),

    SUPERTEAMLEADER("superteamleader", "начальник отдела"),

    INTERNAL_AD_ADMIN("internal_ad_admin", "администратор внутренней рекламы(только Банана)"),

    INTERNAL_AD_MANAGER("internal_ad_manager", "менеджер внутренней рекламы(только Банана)"),

    INTERNAL_AD_SUPERREADER("internal_ad_superreader",
            "суперсмотритель внутренней рекламы(только Банана)"),

    LIMITED_SUPPORT("limited_support", "саппорт с ограниченным доступом"),

    DEVELOPER("developer", "разработчик");

    private static final Map<String, IdmRole> ENUMS = Arrays.stream(values())
            .collect(Collectors.toMap(IdmRole::getTypedValue, e -> e));

    private final String typedValue;
    private final String name;

    IdmRole(String typedValue, String name) {
        this.typedValue = typedValue;
        this.name = name;
    }

    public String getTypedValue() {
        return typedValue;
    }

    public static IdmRole fromTypedValue(@Nullable String typedValue) {
        if (typedValue == null) {
            return null;
        }
        IdmRole result = ENUMS.get(typedValue);
        if (result == null) {
            throw new IllegalArgumentException("Unknown enum typed value " + typedValue);
        }
        return result;
    }

    public String getName() {
        return name;
    }

    public static boolean isValidRole(@Nullable String typedValue) {
        return (typedValue != null) && ENUMS.containsKey(typedValue);
    }
}
