package ru.yandex.direct.intapi.entity.idm.model;

import java.util.Objects;
import java.util.Set;

import com.google.common.collect.ImmutableSet;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

/**
 * Объект с описанием idm роли пользователя
 */
public class IdmUserRole implements Model {
    public static final ModelProperty<IdmUserRole, String> DOMAIN_LOGIN =
            ModelProperty.create(IdmUserRole.class, "domainLogin", IdmUserRole::getDomainLogin,
                    IdmUserRole::setDomainLogin);

    public static final ModelProperty<IdmUserRole, String> PASSPORT_LOGIN =
            ModelProperty.create(IdmUserRole.class, "passportLogin", IdmUserRole::getPassportLogin,
                    IdmUserRole::setPassportLogin);

    public static final ModelProperty<IdmUserRole, Long> UID =
            ModelProperty.create(IdmUserRole.class, "uid", IdmUserRole::getUid, IdmUserRole::setUid);

    public static final ModelProperty<IdmUserRole, IdmRole> ROLE =
            ModelProperty.create(IdmUserRole.class, "role", IdmUserRole::getRole, IdmUserRole::setRole);

    private String domainLogin;

    private String passportLogin;

    private Long uid;

    private IdmRole role;

    public String getDomainLogin() {
        return domainLogin;
    }

    public void setDomainLogin(String domainLogin) {
        this.domainLogin = domainLogin;
    }

    public IdmUserRole withDomainLogin(String domainLogin) {
        setDomainLogin(domainLogin);
        return this;
    }

    public String getPassportLogin() {
        return passportLogin;
    }

    public void setPassportLogin(String passportLogin) {
        this.passportLogin = passportLogin;
    }

    public IdmUserRole withPassportLogin(String passportLogin) {
        setPassportLogin(passportLogin);
        return this;
    }

    public Long getUid() {
        return uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public IdmUserRole withUid(Long uid) {
        setUid(uid);
        return this;
    }

    public IdmRole getRole() {
        return role;
    }

    public void setRole(IdmRole role) {
        this.role = role;
    }

    public IdmUserRole withRole(IdmRole role) {
        setRole(role);
        return this;
    }

    public static Set<ModelProperty> allModelProperties() {
        return ImmutableSet.of(
                DOMAIN_LOGIN,
                PASSPORT_LOGIN,
                ROLE
        );
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ru.yandex.direct.core.entity.idm.model.IdmUserRole{");
        sb.append("domainLogin=").append(domainLogin);
        sb.append(", passportLogin=").append(passportLogin);
        sb.append(", uid=").append(uid);
        sb.append(", role=").append(role);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IdmUserRole that = (IdmUserRole) o;
        return Objects.equals(domainLogin, that.domainLogin)
                && Objects.equals(passportLogin, that.passportLogin)
                && Objects.equals(uid, that.uid)
                && Objects.equals(role, that.role);
    }

    @Override
    public int hashCode() {
        return Objects.hash(
                domainLogin,
                passportLogin,
                uid,
                role
        );
    }
}
