package ru.yandex.direct.intapi.entity.idm.model;

public class RemoveRoleEmailParameters {
    private final String managerLogin;
    private final String domainLogin;
    private final String roleName;
    private final String errorText;

    private RemoveRoleEmailParameters(String managerLogin, String domainLogin,
                                      String roleName, String errorText) {
        this.managerLogin = managerLogin;
        this.domainLogin = domainLogin;
        this.roleName = roleName;
        this.errorText = errorText;
    }

    public String getManagerLogin() {
        return managerLogin;
    }

    public String getDomainLogin() {
        return domainLogin;
    }

    public String getRoleName() {
        return roleName;
    }

    public String getErrorText() {
        return errorText;
    }

    public static class Builder {
        private String managerLogin;
        private String domainLogin;
        private String roleName;
        private String errorText;

        public Builder setManagerLogin(String managerLogin) {
            this.managerLogin = managerLogin;
            return this;
        }

        public Builder setDomainLogin(String domainLogin) {
            this.domainLogin = domainLogin;
            return this;
        }

        public Builder setRoleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public Builder setErrorText(String errorText) {
            this.errorText = errorText;
            return this;
        }

        public RemoveRoleEmailParameters build() {
            return new RemoveRoleEmailParameters(managerLogin, domainLogin,
                    roleName, errorText);
        }
    }
}
