package ru.yandex.direct.intapi.entity.idm.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import static ru.yandex.direct.intapi.entity.idm.converter.IdmCommonNames.CLIENT_ID_SLUG;
import static ru.yandex.direct.intapi.entity.idm.converter.IdmCommonNames.PASSPORT_LOGIN;


public class RoleAdditionalFields {
    @JsonProperty(PASSPORT_LOGIN)
    private String passportLogin;

    @JsonProperty(CLIENT_ID_SLUG)
    private Long clientId;

    public String getPassportLogin() {
        return passportLogin;
    }

    public RoleAdditionalFields withPassportLogin(String passportLogin) {
        this.passportLogin = passportLogin;
        return this;
    }

    public Long getClientId() {
        return clientId;
    }

    public RoleAdditionalFields withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }
}
