package ru.yandex.direct.intapi.entity.idm.model;

import javax.annotation.Nullable;

import ru.yandex.direct.rbac.RbacRole;

public enum RoleWithTeamleaders {
    SUPER,
    SUPERREADER,
    SUPPORT,
    PLACER,
    MEDIA,
    MANAGER,
    INTERNAL_AD_ADMIN,
    INTERNAL_AD_MANAGER,
    INTERNAL_AD_SUPERREADER,
    LIMITED_SUPPORT,
    AGENCY,
    CLIENT,
    EMPTY,
    SUPERTEAMLEADER,
    TEAMLEADER,
    DEVELOPER;

    @Nullable
    public static RoleWithTeamleaders fromRbacRole(@Nullable RbacRole rbacRole) {
        if (rbacRole == null) {
            return null;
        }
        switch (rbacRole) {
            case SUPER:
                return RoleWithTeamleaders.SUPER;
            case SUPERREADER:
                return RoleWithTeamleaders.SUPERREADER;
            case SUPPORT:
                return RoleWithTeamleaders.SUPPORT;
            case PLACER:
                return RoleWithTeamleaders.PLACER;
            case MEDIA:
                return RoleWithTeamleaders.MEDIA;
            case MANAGER:
                return RoleWithTeamleaders.MANAGER;
            case INTERNAL_AD_ADMIN:
                return RoleWithTeamleaders.INTERNAL_AD_ADMIN;
            case INTERNAL_AD_MANAGER:
                return RoleWithTeamleaders.INTERNAL_AD_MANAGER;
            case INTERNAL_AD_SUPERREADER:
                return RoleWithTeamleaders.INTERNAL_AD_SUPERREADER;
            case LIMITED_SUPPORT:
                return RoleWithTeamleaders.LIMITED_SUPPORT;
            case AGENCY:
                return RoleWithTeamleaders.AGENCY;
            case CLIENT:
                return RoleWithTeamleaders.CLIENT;
            case EMPTY:
                return RoleWithTeamleaders.EMPTY;
            default:
                throw new IllegalStateException("No such role: " + rbacRole);
        }
    }

    @Nullable
    public static RoleWithTeamleaders fromIdmRole(@Nullable IdmRole idmRole) {
        if (idmRole == null) {
            return null;
        }
        switch (idmRole) {
            case SUPER:
                return RoleWithTeamleaders.SUPER;
            case SUPERREADER:
                return RoleWithTeamleaders.SUPERREADER;
            case SUPPORT:
                return RoleWithTeamleaders.SUPPORT;
            case PLACER:
                return RoleWithTeamleaders.PLACER;
            case MEDIA:
                return RoleWithTeamleaders.MEDIA;
            case MANAGER:
                return RoleWithTeamleaders.MANAGER;
            case TEAMLEADER:
                return RoleWithTeamleaders.TEAMLEADER;
            case SUPERTEAMLEADER:
                return RoleWithTeamleaders.SUPERTEAMLEADER;
            case INTERNAL_AD_ADMIN:
                return RoleWithTeamleaders.INTERNAL_AD_ADMIN;
            case INTERNAL_AD_MANAGER:
                return RoleWithTeamleaders.INTERNAL_AD_MANAGER;
            case INTERNAL_AD_SUPERREADER:
                return RoleWithTeamleaders.INTERNAL_AD_SUPERREADER;
            case LIMITED_SUPPORT:
                return RoleWithTeamleaders.LIMITED_SUPPORT;
            case DEVELOPER:
                return RoleWithTeamleaders.DEVELOPER;
            default:
                throw new IllegalStateException("No such role: " + idmRole);
        }
    }
}
