package ru.yandex.direct.intapi.entity.idm.service.typesupport;

import java.util.Comparator;
import java.util.List;

import ru.yandex.direct.intapi.entity.idm.container.LastReturnedRoleInfo;
import ru.yandex.direct.intapi.entity.idm.model.GetRolesResponseItem;

import static java.util.Collections.emptyList;
import static java.util.Comparator.comparing;
import static java.util.Comparator.naturalOrder;
import static java.util.Comparator.nullsFirst;

public abstract class AbstractPagesRolesSupplier implements RolesPagedSupplier {

    final Comparator<GetRolesResponseItem> notShardedRolesComparator = getNotShardedRolesComparator();

    private Comparator<GetRolesResponseItem> getNotShardedRolesComparator() {
        Comparator<GetRolesResponseItem> roleComparing =
                comparing(item -> getRolePriority(item.getRoleName()));
        Comparator<GetRolesResponseItem> clientIdComparing =
                comparing(GetRolesResponseItem::getClientId, nullsFirst(naturalOrder()));
        Comparator<GetRolesResponseItem> internalUidComparing =
                comparing(GetRolesResponseItem::getInternalUid, nullsFirst(naturalOrder()));
        Comparator<GetRolesResponseItem> supportIdComparing =
                comparing(GetRolesResponseItem::getSupportId, nullsFirst(naturalOrder()));
        Comparator<GetRolesResponseItem> groupIdComparing =
                comparing(GetRolesResponseItem::getGroupId, nullsFirst(naturalOrder()));
        return roleComparing
                .thenComparing(clientIdComparing)
                .thenComparing(internalUidComparing)
                .thenComparing(supportIdComparing)
                .thenComparing(groupIdComparing);
    }

    int getRolePriority(String roleName) {
        return 0;
    }

    @Override
    public List<GetRolesResponseItem> getNextPage(LastReturnedRoleInfo lastRole, int limit) {
        if (limit < 1) {
            return emptyList();
        }
        if (lastRole.getRoleName() != null && !isSupportedRole(lastRole.getRoleName())) {
            String errorMessage = String.format("Role '%s' isn't supported in '%s' supplier ",
                    lastRole.getRoleName(), this.getClass().getName());
            throw new IllegalArgumentException(errorMessage);
        }
        return getRoleItems(lastRole, limit);
    }

    abstract List<GetRolesResponseItem> getRoleItems(LastReturnedRoleInfo lastRole, int limit);

}
