package ru.yandex.direct.intapi.entity.idm.service.typesupport;

import java.util.Arrays;
import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.idm.model.IdmGroupRole;
import ru.yandex.direct.core.entity.idm.service.IdmGroupsRolesService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.intapi.entity.idm.container.LastReturnedRoleInfo;
import ru.yandex.direct.intapi.entity.idm.converter.GetRolesResponseConverter;
import ru.yandex.direct.intapi.entity.idm.model.GetRolesResponseItem;
import ru.yandex.direct.intapi.entity.idm.model.IdmGroupRoleName;

import static java.util.stream.Collectors.toUnmodifiableSet;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Service
@ParametersAreNonnullByDefault
public class GroupRolesPagedSupplier extends AbstractPagesRolesSupplier {

    private static final Set<String> ROLE_NAMES = Arrays.stream(IdmGroupRoleName.values())
            .map(IdmGroupRoleName::getTypedValue)
            .collect(toUnmodifiableSet());

    private final IdmGroupsRolesService idmGroupsRolesService;

    @Autowired
    public GroupRolesPagedSupplier(IdmGroupsRolesService idmGroupsRolesService) {
        this.idmGroupsRolesService = idmGroupsRolesService;
    }

    @Override
    public boolean isSupportedRole(String roleName) {
        return ROLE_NAMES.contains(roleName);
    }

    @Override
    public List<GetRolesResponseItem> getRoleItems(LastReturnedRoleInfo lastRole, int limit) {
        IdmGroupRole lastGroupRole = lastRole.getRoleName() != null ?
                new IdmGroupRole()
                        .withClientId(ClientId.fromLong(lastRole.getClientId()))
                        .withIdmGroupId(lastRole.getGroupId().longValue())
                : null;
        List<IdmGroupRole> pagedIdmGroupRoles = idmGroupsRolesService.getNextPageGroupRoles(lastGroupRole, limit);
        return mapList(pagedIdmGroupRoles, GetRolesResponseConverter::toGetRolesResponseItem);
    }

}
