package ru.yandex.direct.intapi.entity.idm.service.typesupport;

import java.util.List;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.client.model.ClientPrimaryManager;
import ru.yandex.direct.core.entity.client.service.ClientPrimaryManagerService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.intapi.entity.idm.container.LastReturnedRoleInfo;
import ru.yandex.direct.intapi.entity.idm.converter.GetRolesResponseConverter;
import ru.yandex.direct.intapi.entity.idm.model.GetRolesResponseItem;

import static ru.yandex.direct.intapi.entity.idm.converter.IdmCommonNames.MAIN_MANAGER_ROLE_SLUG_NAME;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Service
@ParametersAreNonnullByDefault
public class MainManagerRolesPagedSupplier extends AbstractPagesRolesSupplier {

    private final ClientPrimaryManagerService clientPrimaryManagerService;

    @Autowired
    public MainManagerRolesPagedSupplier(ClientPrimaryManagerService clientPrimaryManagerService) {
        this.clientPrimaryManagerService = clientPrimaryManagerService;
    }

    @Override
    public boolean isSupportedRole(String roleName) {
        return Objects.equals(MAIN_MANAGER_ROLE_SLUG_NAME, roleName);
    }

    @Override
    public List<GetRolesResponseItem> getRoleItems(LastReturnedRoleInfo lastRole, int limit) {
        ClientId lastClientId = lastRole.getRoleName() != null ? ClientId.fromLong(lastRole.getClientId()) : null;
        List<ClientPrimaryManager> pagedIdmPrimaryManagers =
                clientPrimaryManagerService.getNextPageIdmPrimaryManagers(lastClientId, limit);
        return mapList(pagedIdmPrimaryManagers, GetRolesResponseConverter::toGetRolesResponseItem);
    }

}
