package ru.yandex.direct.intapi.entity.idm.service.typesupport;

import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.intapi.entity.idm.container.LastReturnedRoleInfo;
import ru.yandex.direct.intapi.entity.idm.converter.GetRolesResponseConverter;
import ru.yandex.direct.intapi.entity.idm.model.GetRolesResponseItem;
import ru.yandex.direct.intapi.entity.idm.model.IdmRole;
import ru.yandex.direct.intapi.entity.idm.service.IdmGetRolesService;

import static ru.yandex.direct.intapi.entity.idm.converter.GetRolesResponseConverter.toGetRolesResponseItem;

@Service
@ParametersAreNonnullByDefault
public class PersonalRolesPagedSupplier extends AbstractPagesRolesSupplier {
    private static final Map<String, Integer> ROLE_PRIORITY_BY_NAME = StreamEx.of(IdmRole.values())
            .map(IdmRole::getTypedValue)
            .zipWith(IntStreamEx.range(1, Integer.MAX_VALUE, 1))
            .toMap();
    private static final String FIRST_ROLE = IdmRole.values()[0].getTypedValue();

    private final IdmGetRolesService idmGetRolesService;

    @Autowired
    public PersonalRolesPagedSupplier(IdmGetRolesService idmGetRolesService) {
        this.idmGetRolesService = idmGetRolesService;
    }

    @Override
    int getRolePriority(String roleName) {
        return ROLE_PRIORITY_BY_NAME.get(roleName);
    }

    @Override
    public boolean isSupportedRole(String roleName) {
        return ROLE_PRIORITY_BY_NAME.containsKey(roleName);
    }

    @Override
    public List<GetRolesResponseItem> getRoleItems(LastReturnedRoleInfo lastRole, int limit) {
        GetRolesResponseItem lastItem = toGetRolesResponseItem(lastRole, FIRST_ROLE);
        Predicate<GetRolesResponseItem> userRolesFilterPredicate =
                role -> notShardedRolesComparator.compare(lastItem, role) < 0;
        return StreamEx.of(idmGetRolesService.getAllRoles())
                .map(GetRolesResponseConverter::toGetRolesResponseItem)
                .sorted(notShardedRolesComparator)
                .filter(userRolesFilterPredicate)
                .limit(limit)
                .toList();
    }

}
