package ru.yandex.direct.intapi.entity.idm.service.typesupport;

import java.util.List;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.intapi.entity.idm.container.LastReturnedRoleInfo;
import ru.yandex.direct.intapi.entity.idm.converter.GetRolesResponseConverter;
import ru.yandex.direct.intapi.entity.idm.model.GetRolesResponseItem;
import ru.yandex.direct.intapi.entity.idm.model.IdmSupportForClientRole;
import ru.yandex.direct.intapi.entity.idm.service.IdmSupportForClientService;
import ru.yandex.direct.rbac.model.SupportClientRelation;

import static ru.yandex.direct.intapi.entity.idm.converter.IdmCommonNames.SUPPORT_FOR_CLIENT_ROLE_NAME;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Service
@ParametersAreNonnullByDefault
public class SupportForClientRolesPagedSupplier extends AbstractPagesRolesSupplier {

    private final IdmSupportForClientService idmSupportForClientService;

    @Autowired
    public SupportForClientRolesPagedSupplier(IdmSupportForClientService idmSupportForClientService) {
        this.idmSupportForClientService = idmSupportForClientService;
    }

    @Override
    public boolean isSupportedRole(String roleName) {
        return Objects.equals(SUPPORT_FOR_CLIENT_ROLE_NAME, roleName);
    }

    @Override
    public List<GetRolesResponseItem> getRoleItems(LastReturnedRoleInfo lastRole, int limit) {
        SupportClientRelation lastRelation = (lastRole.getRoleName() != null) ?
                new SupportClientRelation()
                        .withSubjectClientId(ClientId.fromLong(lastRole.getClientId()))
                        .withSupportClientId(ClientId.fromLong(lastRole.getSupportId()))
                : null;
        List<IdmSupportForClientRole> roles = idmSupportForClientService.getNextPageRoles(lastRelation, limit);
        return mapList(roles, GetRolesResponseConverter::toGetRolesResponseItem);
    }

}
