package ru.yandex.direct.intapi.entity.image.presentation;

import ru.yandex.direct.core.entity.image.service.validation.ImageDefectIds;
import ru.yandex.direct.intapi.validation.kernel.TranslatableIntapiDefect;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;

import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.defaultIntapiDefect;

public class ImageDefectPresentations {
    private ImageDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableIntapiDefect> imageDefectPresentationRegistry() {
        return DefaultDefectPresentationRegistry.builder()
                .register(ImageDefectIds.Gen.IMAGE_CONTAINS_ANIMATION, defaultIntapiDefect())
                .register(ImageDefectIds.Gen.IMAGE_MIME_TYPE_IS_NOT_SUPPORTED, defaultIntapiDefect())
                .register(ImageDefectIds.Gen.INVALID_IMAGE_FILE, defaultIntapiDefect())
                .register(ImageDefectIds.Gen.INVALID_IMAGE_URL, defaultIntapiDefect())
                .register(ImageDefectIds.SizesDefects.IMAGE_SIZES_GREATER_THAN_MAX, defaultIntapiDefect())
                .register(ImageDefectIds.Format.IMAGE_FILE_FORMAT_NOT_ALLOWED, defaultIntapiDefect())
                .register(ImageDefectIds.Gen.IMAGE_SIZE_IS_NOT_ALLOWED, defaultIntapiDefect())
                .register(ImageDefectIds.Gen.IMAGE_SIZE_IS_NOT_ALLOWED_MC_BANNER, defaultIntapiDefect())
                .register(ImageDefectIds.Gen.IMAGE_FILE_SIZE_GREATER_THAN_MAX, defaultIntapiDefect())
                .build();
    }
}
