package ru.yandex.direct.intapi.entity.image.service;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.image.container.BannerImageType;
import ru.yandex.direct.core.entity.image.container.UploadedBannerImageInformation;
import ru.yandex.direct.core.entity.image.model.BannerImageSource;
import ru.yandex.direct.core.entity.image.service.ImageService;
import ru.yandex.direct.core.entity.internalads.model.ResourceInfo;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.intapi.entity.image.model.BannerImageUploadResponse;
import ru.yandex.direct.intapi.validation.kernel.ValidationResultConversionService;
import ru.yandex.direct.intapi.validation.model.IntapiResponse;
import ru.yandex.direct.result.Result;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.web.core.entity.banner.service.validation.BannerImageValidationService;

import static ru.yandex.direct.core.validation.ValidationUtils.hasValidationIssues;
import static ru.yandex.direct.web.core.entity.banner.converter.BannerImageConverter.toWebUploadedImage;

@Service
@ParametersAreNonnullByDefault
public class BannerImageService {
    private final BannerImageValidationService bannerImageValidationService;
    private final ValidationResultConversionService validationResultConversionService;
    private final ImageService bannerImageService;

    public BannerImageService(
            BannerImageValidationService bannerImageValidationService,
            ValidationResultConversionService validationResultConversionService,
            ImageService bannerImageService) {
        this.bannerImageValidationService = bannerImageValidationService;
        this.validationResultConversionService = validationResultConversionService;
        this.bannerImageService = bannerImageService;
    }

    public IntapiResponse saveImage(String url, String imageTypeStr, ClientId clientId) {
        BannerImageType imageType = BannerImageType.valueOf(imageTypeStr.toUpperCase());

        return saveImage(url, imageType, null, clientId);
    }

    private IntapiResponse saveImage(String url, BannerImageType imageType, @Nullable ResourceInfo resourceInfo,
            ClientId clientId) {

        ValidationResult<String, Defect> validation = bannerImageValidationService.validateImageUrl(url);

        if (validation.hasAnyErrors()) {
            return validationResultConversionService.buildValidationResponse(validation);
        }

        @SuppressWarnings("ConstantConditions")
        Result<UploadedBannerImageInformation> operationResult =
                bannerImageService.saveImageFromUrl(clientId, url, imageType, BannerImageSource.DIRECT, resourceInfo);
        if (hasValidationIssues(operationResult)) {
            return validationResultConversionService.buildValidationResponse(operationResult);
        }
        return new BannerImageUploadResponse()
                .withResult(toWebUploadedImage(operationResult.getResult()));
    }

}
