package ru.yandex.direct.intapi.entity.internalads.controller;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import ru.yandex.direct.core.entity.internalads.model.ReadOnlyDirectTemplateResource;
import ru.yandex.direct.core.entity.internalads.service.TemplateResourceService;
import ru.yandex.direct.intapi.ErrorResponse;
import ru.yandex.direct.intapi.entity.internalads.model.TemplateResourceResponse;
import ru.yandex.direct.tvm.AllowServices;

import static ru.yandex.direct.tvm.TvmService.DIRECT_DEVELOPER;
import static ru.yandex.direct.tvm.TvmService.DIRECT_WEB_PROD;
import static ru.yandex.direct.tvm.TvmService.DIRECT_WEB_TEST;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

/**
 * Ручки для получения параметров ресурсов(переменных), необходимых для шаблона
 */
@ParametersAreNonnullByDefault
@Controller
@Api(value = "API для получения информации о параметрах ресурсов")
@RequestMapping(path = "/internalads")
@AllowServices(production = {DIRECT_WEB_PROD}, testing = {DIRECT_WEB_TEST, DIRECT_DEVELOPER})
public class TemplateResourceController {
    private final TemplateResourceService templateResourceService;

    @Autowired
    public TemplateResourceController(TemplateResourceService templateResourceService) {
        this.templateResourceService = templateResourceService;
    }

    @ApiOperation(
            value = "template-resource",
            nickname = "template-resource",
            httpMethod = "GET"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = ErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = List.class)
            }
    )
    @RequestMapping(path = "/template-resource", method = RequestMethod.GET)
    @ResponseBody
    public List<TemplateResourceResponse> getTemplateResourceByTemplateIds(
            @RequestParam(value = "template_ids") Set<Long> templateIds) {
        var templateResourceList = templateResourceService.getReadonlyByTemplateIds(templateIds).values();
        return mapList(templateResourceList, TemplateResourceController::convertTemplateResource);

    }

    private static TemplateResourceResponse convertTemplateResource(ReadOnlyDirectTemplateResource resource) {
        return new TemplateResourceResponse(resource.getId(), resource.getTemplateId(), resource.getDescription());
    }
}
