package ru.yandex.direct.intapi.entity.internalads.model;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonGetter;

import ru.yandex.direct.web.core.model.WebSuccessResponse;

@ParametersAreNonnullByDefault
public class CanControlPlaceResponse extends WebSuccessResponse {
    private final Long operatorUid;
    private final Long productClientId;
    private final Long placeId;
    private final Boolean hasAccess;

    public CanControlPlaceResponse(Long operatorUid, Long productClientId, Long placeId, Boolean hasAccess) {
        this.operatorUid = operatorUid;
        this.productClientId = productClientId;
        this.placeId = placeId;
        this.hasAccess = hasAccess;
    }

    @JsonGetter("operator_uid")
    public Long getOperatorUid() {
        return operatorUid;
    }

    @JsonGetter("product_client_id")
    public Long getProductClientId() {
        return productClientId;
    }

    @JsonGetter("place_id")
    public Long getPlaceId() {
        return placeId;
    }

    @JsonGetter("has_access")
    public Boolean getHasAccess() {
        return hasAccess;
    }
}
