package ru.yandex.direct.intapi.entity.internalads.model;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonGetter;


@ParametersAreNonnullByDefault
public class InternalAdResponse {
    private final String description;
    private final Long templateId;
    private final List<TemplateVariableResponse> templateVariables;

    public InternalAdResponse(String description, Long templateId, List<TemplateVariableResponse> templateVariables) {
        this.description = description;
        this.templateId = templateId;
        this.templateVariables = templateVariables;
    }

    @JsonGetter("description")
    public String getDescription() {
        return description;
    }

    @JsonGetter("template_id")
    public Long getTemplateId() {
        return templateId;
    }

    @JsonGetter("template_variables")
    public List<TemplateVariableResponse> getTemplateVariables() {
        return templateVariables;
    }
}
