package ru.yandex.direct.intapi.entity.internalads.model;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonGetter;

import ru.yandex.direct.web.core.model.WebSuccessResponse;

@ParametersAreNonnullByDefault
public class PlaceListResponse extends WebSuccessResponse {
    private final Long operatorUid;
    private final Long productClientId;
    private final List<PlaceResponse> places;

    public PlaceListResponse(Long operatorUid, Long productClientId, List<PlaceResponse> places) {
        this.operatorUid = operatorUid;
        this.productClientId = productClientId;
        this.places = places;
    }

    @JsonGetter("places")
    public List<PlaceResponse> getPlaces() {
        return places;
    }

    @JsonGetter("operator_ud")
    public Long getOperatorUid() {
        return operatorUid;
    }

    @JsonGetter("product_client_id")
    public Long getProductClientId() {
        return productClientId;
    }
}
