package ru.yandex.direct.intapi.entity.internalads.presentation;

import ru.yandex.direct.core.entity.internalads.restriction.InternalAdRestrictionDefects;
import ru.yandex.direct.core.entity.internalads.service.validation.defects.InternalAdDefectIds;
import ru.yandex.direct.core.entity.internalads.service.validation.defects.InternalAdStringDefectIds;
import ru.yandex.direct.intapi.validation.kernel.TranslatableIntapiDefect;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;

import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.defaultIntapiDefect;

public class InternalAdsDefectPresentation {

    private InternalAdsDefectPresentation() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableIntapiDefect> internalAdsDefectPresentationRegistry() {
        return DefaultDefectPresentationRegistry.builder()
                .register(InternalAdDefectIds.UNKNOWN_CLIENT_ID, defaultIntapiDefect())
                .register(InternalAdDefectIds.PRODUCT_ACCESS_EXISTS, defaultIntapiDefect())
                .register(InternalAdDefectIds.PRODUCT_ACCESS_DOES_NOT_EXIST, defaultIntapiDefect())
                .register(InternalAdDefectIds.PRODUCT_WITH_THIS_NAME_ALREADY_EXISTS, defaultIntapiDefect())
                .register(InternalAdDefectIds.INVALID_PLACE_ID, defaultIntapiDefect())
                .register(InternalAdDefectIds.TEMPLATE_NOT_FOUND, defaultIntapiDefect())
                .register(InternalAdDefectIds.REQUIRED_IMPRESSION_RATE_DUE_TO_RF_CLOSE_BY_CLICK, defaultIntapiDefect())
                .register(InternalAdStringDefectIds.URL_UNREACHABLE, defaultIntapiDefect())
                .register(InternalAdStringDefectIds.RESOURCE_RESTRICTIONS_NOT_FOLLOWED, defaultIntapiDefect())

                .register(InternalAdRestrictionDefects.Url.URL_NOT_VALID, defaultIntapiDefect())
                .register(InternalAdRestrictionDefects.UrlWithSpaces.URL_HAS_SPACES, defaultIntapiDefect())
                .register(InternalAdRestrictionDefects.Length.TEXT_TOO_SHORT, defaultIntapiDefect())
                .register(InternalAdRestrictionDefects.Length.TEXT_TOO_LONG, defaultIntapiDefect())
                .register(InternalAdRestrictionDefects.Text.TEXT_HAS_SPACES_AROUND, defaultIntapiDefect())
                .register(InternalAdRestrictionDefects.ImageDimension.IMAGE_DIMENSION_TOO_SMALL, defaultIntapiDefect())
                .register(InternalAdRestrictionDefects.ImageDimension.IMAGE_DIMENSION_TOO_BIG, defaultIntapiDefect())
                .register(InternalAdRestrictionDefects.ImageDimension.IMAGE_DIMENSION_NOT_EQUAL, defaultIntapiDefect())
                .register(InternalAdRestrictionDefects.ImageDimension.IMAGE_DIMENSION_NOT_SQUARE, defaultIntapiDefect())
                .register(InternalAdRestrictionDefects.ImageFormat.IMAGE_FORMAT_INVALID, defaultIntapiDefect())
                .register(InternalAdRestrictionDefects.ImageSize.IMAGE_SIZE_KB_TOO_BIG, defaultIntapiDefect())
                .register(InternalAdRestrictionDefects.Gen.FORMAT_INVALID, defaultIntapiDefect())
                .build();
    }
}
