package ru.yandex.direct.intapi.entity.inventori.model;

import java.util.List;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class InventoriResponse {

    @JsonProperty("results")
    private List<InventoriResult> results;

    @JsonProperty("internal_direct_error")
    private String internalError;

    public InventoriResponse() {
    }

    public InventoriResponse(List<InventoriResult> results) {
        this.results = results;
    }

    public InventoriResponse(String internalError) {
        this.internalError = internalError;
    }

    public List<InventoriResult> getResults() {
        return results;
    }

    public void setResults(List<InventoriResult> results) {
        this.results = results;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        InventoriResponse response = (InventoriResponse) o;
        return Objects.equals(results, response.results) &&
                Objects.equals(internalError, response.internalError);
    }

    @Override
    public int hashCode() {
        return Objects.hash(results, internalError);
    }

    @Override
    public String toString() {
        return "InventoriResponse{" +
                "results=" + results +
                "internalError=" + internalError +
                '}';
    }
}
