package ru.yandex.direct.intapi.entity.inventori.model;

import java.util.List;
import java.util.Objects;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.inventori.model.request.CampaignParameters;
import ru.yandex.direct.inventori.model.request.CampaignPredictionRequest;
import ru.yandex.direct.inventori.model.request.InventoriCampaignType;
import ru.yandex.direct.inventori.model.request.Target;

@ParametersAreNonnullByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
@SuppressWarnings("checkstyle:ParameterNumber")
public class InventoriResult extends CampaignPredictionRequest {

    @JsonProperty("error")
    private String error;

    @JsonProperty("error_id")
    private Integer errorId;

    public InventoriResult() {
    }

    private InventoriResult(@Nullable Long campaignId,
                            @Nullable Integer defaultTargetId,
                            InventoriCampaignType campaignType,
                            @Nullable List<Target> targets,
                            CampaignParameters parameters,
                            @Nullable Boolean containsKeywordGroup,
                            @Nullable Boolean isSocial,
                            @Nullable Boolean hasBrandLift) {
        super(campaignId, defaultTargetId, campaignType, targets, parameters, containsKeywordGroup, isSocial,
                hasBrandLift);
    }

    private InventoriResult(@Nonnull Long campaignId,
                            @Nonnull InventoriResultErrorIds errorIdObj,
                            @Nonnull String error) {
        this.campaignId = campaignId;
        this.errorId = errorIdObj.getValue();
        this.error = error;
    }

    private InventoriResult(@Nonnull InventoriResultErrorIds errorIdObj, @Nonnull String error) {
        this.errorId = errorIdObj.getValue();
        this.error = error;
    }

    public static InventoriResult success(@Nullable Long campaignId, @Nullable Integer defaultTargetId,
                                          InventoriCampaignType campaignType,
                                          @Nullable List<Target> targets,
                                          @Nullable Boolean isSocial, @Nullable Boolean containsKeywordGroup,
                                          @Nullable Boolean hasBrandLift,
                                          CampaignParameters parameters) {
        return new InventoriResult(campaignId, defaultTargetId, campaignType, targets, parameters, containsKeywordGroup,
                isSocial, hasBrandLift);
    }

    public static InventoriResult success(CampaignPredictionRequest campaignPredictionRequest) {
        return new InventoriResult(
                campaignPredictionRequest.getCampaignId(),
                campaignPredictionRequest.getDefaultTargetId(),
                campaignPredictionRequest.getCampaignType(),
                campaignPredictionRequest.getTargets(),
                campaignPredictionRequest.getParameters(),
                campaignPredictionRequest.containsKeywordGroup(),
                campaignPredictionRequest.getIsSocial(),
                campaignPredictionRequest.getHasBrandlift());
    }

    public static InventoriResult error(Long campaignId, InventoriResultErrorIds errorId, String error) {
        return new InventoriResult(campaignId, errorId, error);
    }

    public String getError() {
        return error;
    }

    public Integer getErrorId() {
        return errorId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        InventoriResult result = (InventoriResult) o;
        return Objects.equals(campaignId, result.campaignId)
                && Objects.equals(defaultTargetId, result.defaultTargetId)
                && Objects.equals(targets, result.targets)
                && Objects.equals(parameters, result.parameters)
                && Objects.equals(isSocial, result.isSocial)
                && Objects.equals(hasBrandlift, result.hasBrandlift)
                && Objects.equals(containsKeywordGroup(), result.containsKeywordGroup())
                && Objects.equals(errorId, result.errorId)
                && Objects.equals(error, result.error);
    }

    @Override
    public int hashCode() {
        return Objects.hash(campaignId, defaultTargetId, targets, parameters, isSocial, hasBrandlift,
                containsKeywordGroup, errorId);
    }

    @Override
    public String toString() {
        return "InventoriResult{" +
                "errorId='" + errorId + '\'' +
                "error='" + error + '\'' +
                "} " + super.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder extends CampaignPredictionRequest.Builder {

        private Builder() {
        }

        public InventoriResult build() {
            return new InventoriResult(campaignId, defaultTargetId, campaignType, targets, parameters,
                    containsKeywordGroup, isSocial, hasBrandlift
            );
        }
    }
}
