package ru.yandex.direct.intapi.entity.inventori.presentation;

import ru.yandex.direct.intapi.validation.kernel.TranslatableIntapiDefect;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;
import ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectTranslations;

import static ru.yandex.direct.core.entity.inventori.service.validation.InventoriDefectIds.String.UNEXPECTED_INVENTORI_COMMON_PROBLEM;
import static ru.yandex.direct.core.entity.inventori.service.validation.InventoriDefectIds.String.UNEXPECTED_INVENTORI_PROBLEM_WITH_CAMPAIGN;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.defaultIntapiDefect;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.paramIntapiDefect;
import static ru.yandex.direct.web.core.entity.inventori.validation.CampaignDefectIds.CampaignDefects.CAMPAIGN_ALREADY_DELETED;
import static ru.yandex.direct.web.core.entity.inventori.validation.CampaignDefectIds.CampaignDefects.CAMPAIGN_NOT_EXISTS;
import static ru.yandex.direct.web.core.entity.inventori.validation.CampaignDefectIds.CampaignTypeDefects.INVALID_CAMPAIGN_TYPE;
import static ru.yandex.direct.web.core.entity.inventori.validation.CampaignDefectIds.GroupsDefects.INVALID_GROUP_TYPE;
import static ru.yandex.direct.web.core.entity.inventori.validation.CampaignDefectIds.StrategyDefects.INVALID_CAMPAIGN_STRATEGY;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.Gen.CONTAINS_KEYWORD_ADGROUPS;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.Gen.INTERNAL_ERROR;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.Gen.NO_GROUPS;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.Gen.NO_SUITABLE_ADGROUPS;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.Gen.UNSUPPORTED_ERROR;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.Number.INVALID_BUDGET;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.Number.INVALID_CPM;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.Number.LOW_REACH;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.String.INVALID_DATES;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.String.INVALID_REQUEST;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.String.INVALID_RF;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.String.UNKNOWN_SEGMENTS;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.String.UNSUPPORTED_SEGMENTS;

public class InventoriDefectPresentations {
    private InventoriDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableIntapiDefect> inventoriDefectPresentationRegistry() {

        InventoriDefectTranslations inventoriDefectTranslations = InventoriDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()
                .register(CAMPAIGN_NOT_EXISTS,
                        paramIntapiDefect(di -> inventoriDefectTranslations.campaignNotFound((Long) di.getValue())))
                .register(CAMPAIGN_ALREADY_DELETED,
                        paramIntapiDefect(di -> inventoriDefectTranslations.campaignAlreadyDeleted(
                                (Long) di.getValue())))
                .register(INVALID_CAMPAIGN_STRATEGY,
                        paramIntapiDefect(di -> inventoriDefectTranslations.invalidCampaignStrategy(
                                (Long) di.getValue(), di.getDefect().params())))
                .register(INVALID_CAMPAIGN_TYPE, defaultIntapiDefect())
                .register(INVALID_GROUP_TYPE,
                        paramIntapiDefect(di -> inventoriDefectTranslations.invalidGroupTypes(
                                (Long) di.getValue(), di.getDefect().params())))
                .register(UNSUPPORTED_ERROR, defaultIntapiDefect())
                .register(INTERNAL_ERROR, defaultIntapiDefect())
                .register(NO_SUITABLE_ADGROUPS, defaultIntapiDefect())
                .register(CONTAINS_KEYWORD_ADGROUPS, defaultIntapiDefect())
                .register(NO_GROUPS, defaultIntapiDefect())
                .register(INVALID_DATES, defaultIntapiDefect())
                .register(INVALID_REQUEST, defaultIntapiDefect())
                .register(INVALID_RF, defaultIntapiDefect())
                .register(UNKNOWN_SEGMENTS, defaultIntapiDefect())
                .register(UNSUPPORTED_SEGMENTS, defaultIntapiDefect())
                .register(LOW_REACH, defaultIntapiDefect())
                .register(INVALID_BUDGET, defaultIntapiDefect())
                .register(INVALID_CPM, defaultIntapiDefect())
                .register(UNEXPECTED_INVENTORI_PROBLEM_WITH_CAMPAIGN,
                        paramIntapiDefect(di -> inventoriDefectTranslations.unexpectedInventoryProblemWithCampaign(
                        (Long) di.getValue(), di.getDefect().params().getAllInvalidSubstrings())))
                .register(UNEXPECTED_INVENTORI_COMMON_PROBLEM, defaultIntapiDefect())
                .build();
    }
}
