package ru.yandex.direct.intapi.entity.keywords.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel
public class CampaignIdAndBannerIdPair {
    public static final String CAMPAIGN_IDENTIFIER = "cid";
    public static final String BANNER_IDENTIFIER = "bid";

    private Long campaignId;
    private Long bannerId;

    @ApiModelProperty(
            value = "Идентификатор кампании",
            required = true
    )
    @JsonProperty(CAMPAIGN_IDENTIFIER)
    public Long getCampaignId() {
        return campaignId;
    }

    public CampaignIdAndBannerIdPair withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    @ApiModelProperty(
            value = "Идентификатор баннера",
            required = true
    )
    @JsonProperty(BANNER_IDENTIFIER)
    public Long getBannerId() {
        return bannerId;
    }

    public CampaignIdAndBannerIdPair withBannerId(Long bannerId) {
        this.bannerId = bannerId;
        return this;
    }
}
