package ru.yandex.direct.intapi.entity.keywords.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.direct.intapi.common.converter.directtsv.DirectTsvColumn;
import ru.yandex.direct.intapi.common.converter.directtsv.DirectTsvFieldsOrder;

@ApiModel
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE, getterVisibility = JsonAutoDetect.Visibility.NONE)
@DirectTsvFieldsOrder({"cid", "bid", "bids_id", "phrase"})
public class GetKeywordsByCidAndBidPairResult {
    private Long cid;
    private Long bid;
    private Long keywordId;
    private String keyword;

    public GetKeywordsByCidAndBidPairResult withCid(Long cid) {
        this.cid = cid;
        return this;
    }

    @ApiModelProperty(
            value = "Идентификатор кампании",
            required = true
    )
    @JsonProperty("cid")
    public Long getCid() {
        return cid;
    }

    public GetKeywordsByCidAndBidPairResult withBid(Long bid) {
        this.bid = bid;
        return this;
    }

    @ApiModelProperty(
            value = "Идентификатор баннера",
            required = true
    )
    @JsonProperty("bid")
    public Long getBid() {
        return bid;
    }

    public GetKeywordsByCidAndBidPairResult withKeywordId(Long keywordId) {
        this.keywordId = keywordId;
        return this;
    }

    @ApiModelProperty(
            value = "Идентификатор ключевой фразы",
            required = true
    )
    @JsonProperty("keywordId")
    @DirectTsvColumn("bids_id")
    public Long getKeywordId() {
        return keywordId;
    }

    public GetKeywordsByCidAndBidPairResult withKeyword(String keyword) {
        this.keyword = keyword;
        return this;
    }

    @ApiModelProperty(
            value = "Текст ключевой фразы",
            required = true
    )
    @JsonProperty("keyword")
    @DirectTsvColumn("phrase")
    public String getKeyword() {
        return keyword;
    }
}
