package ru.yandex.direct.intapi.entity.keywords.presentation;

import ru.yandex.direct.core.entity.keyword.service.validation.KeywordDefectTranslations;
import ru.yandex.direct.core.entity.keyword.service.validation.phrase.advqphrase.AdvqPhraseDefectIds;
import ru.yandex.direct.core.entity.keyword.service.validation.phrase.advqphrase.AdvqPhraseDefectTranslations;
import ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseDefectTranslations;
import ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseDefectIds;
import ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseDefectTranslations;
import ru.yandex.direct.i18n.types.Identity;
import ru.yandex.direct.intapi.validation.kernel.TranslatableIntapiDefect;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;

import static ru.yandex.direct.core.entity.keyword.service.validation.KeywordDefectIds.Gen.AD_GROUP_NOT_FOUND;
import static ru.yandex.direct.core.entity.keyword.service.validation.KeywordDefectIds.Gen.AUTOTARGETING_PREFIX_IS_NOT_ALLOWED;
import static ru.yandex.direct.core.entity.keyword.service.validation.KeywordDefectIds.Gen.DUPLICATED_WITH_UPDATED;
import static ru.yandex.direct.core.entity.keyword.service.validation.KeywordDefectIds.Gen.KEYWORD_ALREADY_SUSPENDED;
import static ru.yandex.direct.core.entity.keyword.service.validation.KeywordDefectIds.Gen.KEYWORD_DUPLICATED_WITH_EXISTING;
import static ru.yandex.direct.core.entity.keyword.service.validation.KeywordDefectIds.Gen.KEYWORD_DUPLICATED_WITH_NEW;
import static ru.yandex.direct.core.entity.keyword.service.validation.KeywordDefectIds.Gen.KEYWORD_NOT_SUSPENDED;
import static ru.yandex.direct.core.entity.keyword.service.validation.KeywordDefectIds.Gen.NOT_ACCEPTABLE_AD_GROUP_TYPE;
import static ru.yandex.direct.core.entity.keyword.service.validation.KeywordDefectIds.Gen.NO_RIGHTS_IN_ARCHIVED_ADGROUP;
import static ru.yandex.direct.core.entity.keyword.service.validation.KeywordDefectIds.Keyword.MAX_KEYWORDS_PER_AD_GROUP_EXCEEDED;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseDefectIds.Gen.BOTH_QUOTES_AND_MINUS_WORDS;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseDefectIds.Gen.BRACKETS_IN_MINUS_WORDS;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseDefectIds.Gen.INCORRECT_USE_OF_PARENTHESIS;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseDefectIds.Gen.INVALID_APOSTROPHE;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseDefectIds.Gen.INVALID_BRACKETS;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseDefectIds.Gen.INVALID_EXCLAMATION_MARK;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseDefectIds.Gen.INVALID_MINUS_MARK;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseDefectIds.Gen.INVALID_PLUS_MARK;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseDefectIds.Gen.INVALID_POINT;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseDefectIds.Gen.INVALID_QUOTES;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseDefectIds.Gen.MINUS_WORD_INSIDE_BRACKETS_OR_QUOTES;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseDefectIds.Gen.NO_PLUS_WORDS;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseDefectIds.Gen.ONLY_STOP_WORDS;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseDefectIds.Gen.PLUS_MARK_IN_BRACKETS;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseDefectIds.String.ILLEGAL_CHARACTERS;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseDefectIds.String.MINUS_WORD_DELETE_PLUS_WORD;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseDefectIds.String.NOT_SINGLE_MINUS_WORD;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseDefectIds.String.TOO_LONG_KEYWORD;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseDefectIds.String.TOO_LONG_MINUS_WORD;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseDefectIds.String.TOO_LONG_WORD;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseDefectIds.String.TOO_MANY_WORDS;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.defaultIntapiDefect;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.intapiDefect;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.paramIntapiDefect;

public class KeywordsDefectPresentations {

    private KeywordsDefectPresentations() {
    }

    /**
     * Общие ошибки модели Keyword
     */
    public static DefaultDefectPresentationRegistry<TranslatableIntapiDefect> keywordDefectPresentationRegistry() {
        KeywordDefectTranslations translations = KeywordDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()
                .register(MAX_KEYWORDS_PER_AD_GROUP_EXCEEDED,
                        paramIntapiDefect(di -> translations.adGroupKeywordLimitExceeded(
                                new Identity(di.getDefect().params().getMaxKeywords().longValue()))))
                .register(NOT_ACCEPTABLE_AD_GROUP_TYPE,
                        intapiDefect(translations.keywordInNotAcceptableAdGroupType()))
                .register(NO_RIGHTS_IN_ARCHIVED_ADGROUP,
                        intapiDefect(translations.keywordModificationInArchivedAdGroup()))
                .register(KEYWORD_DUPLICATED_WITH_NEW,
                        defaultIntapiDefect())
                .register(DUPLICATED_WITH_UPDATED,
                        defaultIntapiDefect())
                .register(KEYWORD_DUPLICATED_WITH_EXISTING,
                        defaultIntapiDefect())
                .register(AD_GROUP_NOT_FOUND,
                        defaultIntapiDefect())
                .register(KEYWORD_ALREADY_SUSPENDED,
                        defaultIntapiDefect())
                .register(KEYWORD_NOT_SUSPENDED,
                        defaultIntapiDefect())
                .register(AUTOTARGETING_PREFIX_IS_NOT_ALLOWED,
                        defaultIntapiDefect())
                .build();
    }

    /**
     * Ошибки текстов фраз
     */
    public static DefaultDefectPresentationRegistry<TranslatableIntapiDefect> phraseDefectPresentationRegistry() {
        PhraseDefectTranslations translations = PhraseDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()
                .register(TOO_LONG_KEYWORD,
                        paramIntapiDefect(di -> translations.tooLongKeyword(
                                di.getDefect().params().getMaxLength(),
                                (String) di.getValue())))
                .register(TOO_LONG_WORD,
                        paramIntapiDefect(di -> translations.tooLongWord(
                                di.getDefect().params().getMaxLength(), (String) di.getValue())))
                .register(TOO_LONG_MINUS_WORD,
                        paramIntapiDefect(di -> translations.tooLongWord(
                                di.getDefect().params().getMaxLength(), (String) di.getValue())))
                .register(ILLEGAL_CHARACTERS,
                        paramIntapiDefect(di -> translations.invalidChars(
                                di.getDefect().params().getAllInvalidSubstrings(),
                                (String) di.getValue())))
                .register(INVALID_QUOTES,
                        paramIntapiDefect(di -> translations.invalidQuotes((String) di.getValue())))
                .register(INVALID_BRACKETS,
                        paramIntapiDefect(di -> translations.invalidBrackets((String) di.getValue())))
                .register(INVALID_EXCLAMATION_MARK,
                        paramIntapiDefect(di -> translations.invalidExclamationMark((String) di.getValue())))
                .register(INVALID_PLUS_MARK,
                        paramIntapiDefect(di -> translations.invalidPlus((String) di.getValue())))
                .register(INVALID_MINUS_MARK,
                        paramIntapiDefect(di -> translations.invalidMinus((String) di.getValue())))
                .register(INVALID_POINT,
                        paramIntapiDefect(di -> translations.invalidPoint((String) di.getValue())))
                .register(INVALID_APOSTROPHE,
                        paramIntapiDefect(di -> translations.invalidApostrophe((String) di.getValue())))
                .register(BOTH_QUOTES_AND_MINUS_WORDS,
                        paramIntapiDefect(di -> translations.bothQuotesAndMinusWords((String) di.getValue())))
                .register(MINUS_WORD_INSIDE_BRACKETS_OR_QUOTES,
                        paramIntapiDefect(di -> translations.minusWordsInsideBracketsOrQuotes((String) di.getValue())))
                .register(PLUS_MARK_IN_BRACKETS,
                        paramIntapiDefect(di -> translations.plusMarkInsideBrackets((String) di.getValue())))
                .register(BRACKETS_IN_MINUS_WORDS,
                        paramIntapiDefect(di -> translations.bracketsInMinusWords((String) di.getValue())))
                .register(NOT_SINGLE_MINUS_WORD,
                        paramIntapiDefect(di -> translations.notSingleMinusWord((String) di.getValue())))
                .register(NO_PLUS_WORDS,
                        paramIntapiDefect(di -> translations.noPlusWords((String) di.getValue())))
                .register(MINUS_WORD_DELETE_PLUS_WORD,
                        paramIntapiDefect(di -> translations.minusWordDeletePlusWord((String) di.getValue())))
                .register(TOO_MANY_WORDS,
                        paramIntapiDefect(di -> translations.tooManyWords(
                                di.getDefect().params().getMaxWords(), (String) di.getValue())))
                .register(ONLY_STOP_WORDS,
                        paramIntapiDefect(di -> translations.onlyStopWords((String) di.getValue())))
                .register(INCORRECT_USE_OF_PARENTHESIS,
                        intapiDefect(translations.invalidParenthesis()))
                .build();
    }

    /**
     * Ошибки advq фраз
     */
    public static DefaultDefectPresentationRegistry<TranslatableIntapiDefect> advqPhraseDefectPresentationRegistry() {
        AdvqPhraseDefectTranslations translations = AdvqPhraseDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()
                .register(AdvqPhraseDefectIds.Gen.CANNOT_CONTAIN_LONE_DOT,
                        intapiDefect(translations.invalidCharsKeywordLoneDotDetailed()))
                .register(AdvqPhraseDefectIds.Gen.UNPAIRED_QUOTES,
                        intapiDefect(translations.invalidCharsUnpairedQuotesDetailed()))
                .register(AdvqPhraseDefectIds.Gen.CONTAINS_ONLY_STOP_WORDS,
                        intapiDefect(translations.stopWordsDetailed()))
                .register(AdvqPhraseDefectIds.Gen.CANNOT_CONTAIN_ONLY_MINUS_WORDS,
                        intapiDefect(translations.minusWordsOnlyDetailed()))
                .register(AdvqPhraseDefectIds.String.TOO_MANY_WORDS,
                        paramIntapiDefect(di -> translations.maxWordsDetailed(
                                di.getDefect().params().getMaxWords())))
                .register(AdvqPhraseDefectIds.String.TOO_LONG_KEYWORD,
                        paramIntapiDefect(di -> translations.keywordMaxLengthDetailed(
                                di.getDefect().params().getMaxLength())))
                .register(AdvqPhraseDefectIds.Gen.UNPAIRED_SQUARE_BRACKETS,
                        intapiDefect(translations.invalidCharsUnpairedSquareBracketsDetailed()))
                .register(AdvqPhraseDefectIds.Gen.EMPTY_OR_NESTED_SQUARE_BRACKETS,
                        intapiDefect(translations.invalidCharsEmptyOrNestedSquareBrackets()))
                .register(AdvqPhraseDefectIds.Gen.MODIFIERS_INSIDE_SQUARE_BRACKETS,
                        intapiDefect(translations.invalidCharsModifiersInsideSquareBrackets()))
                .register(AdvqPhraseDefectIds.Gen.INCORRECT_USE_OF_EXCLAMATION_MARK,
                        intapiDefect(translations.invalidCharsIncorrectUseOfExclamationMarks()))
                .register(AdvqPhraseDefectIds.Gen.INCORRECT_USE_OF_MINUS_SIGN,
                        intapiDefect(translations.invalidCharsIncorrectUseOfMinusSign()))
                .register(AdvqPhraseDefectIds.Gen.INCORRECT_USE_OF_PLUS_SIGN,
                        intapiDefect(translations.invalidCharsIncorrectUseOfPlusSign()))
                .register(AdvqPhraseDefectIds.Gen.NO_MINUS_PHRASES_ONLY_WORDS,
                        intapiDefect(translations.minusWordsNoMinusPhrasesDetailed()))
                .register(AdvqPhraseDefectIds.Gen.MINUS_WORDS_NO_PHRASE_WITH_DOT,
                        intapiDefect(translations.minusWordsPhraseWithDot()))
                .register(AdvqPhraseDefectIds.Gen.INCORRECT_COMBINATION_OF_SPECIAL_SYMBOLS,
                        intapiDefect(translations.minusWordsIncorrectCombinationOfSpecialSymbols()))
                .register(AdvqPhraseDefectIds.Gen.MINUS_WORD_CANNOT_START_FROM_DOT_OR_APOSTROPHE,
                        intapiDefect(translations.minusWordsCantStartWithDotOrApostroph()))
                .register(AdvqPhraseDefectIds.Gen.MINUS_WORD_NOT_IN_QUOTED_PHRASE,
                        intapiDefect(translations.minusWordsNotInQuotedPhrase()))
                .register(AdvqPhraseDefectIds.Gen.ONLY_SINGLE_DOT_BETWEEN_NUMBERS,
                        intapiDefect(translations.minusWordsSingleDotOnly()))
                .register(AdvqPhraseDefectIds.String.MINUS_WORDS_CANNOT_SUBTRACT_PLUS_WORDS,
                        paramIntapiDefect(di -> translations.minusWordsCantSubtractPlusWords(
                                di.getDefect().params().getAllInvalidSubstrings())))
                .build();
    }

    /**
     * Ошибки минус-фраз
     */
    public static DefaultDefectPresentationRegistry<TranslatableIntapiDefect> minusPhraseDefectPresentationRegistry() {
        MinusPhraseDefectTranslations translations = MinusPhraseDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()
                .register(MinusPhraseDefectIds.Gen.MINUS_KEYWORD_IS_INCLUDED_IN_KEYWORD,
                        defaultIntapiDefect())
                .register(MinusPhraseDefectIds.MinusPhrase.ILLEGAL_MINUS_KEYWORD_CHARS,
                        paramIntapiDefect(di -> translations.notAllowedSymbolsInMinusKeywordDetailedWithList(
                                String.join(", ", di.getDefect().params().getSubset()))))
                .register(MinusPhraseDefectIds.MinusPhrase.INVALID_COMBINATION_SPECIAL_SYMBOLS,
                        paramIntapiDefect(di -> translations.wrongSpecialSymbolsUsageInMinusKeywordDetailedWithList(
                                String.join(", ", di.getDefect().params().getSubset()))))
                .register(MinusPhraseDefectIds.MinusPhrase.INVALID_DOT,
                        paramIntapiDefect(di -> translations.invalidDotDetailedWithList(
                                String.join(", ", di.getDefect().params().getSubset()))))
                .register(MinusPhraseDefectIds.MinusPhrase.SEPARATE_DOT,
                        paramIntapiDefect(di -> translations.separateDotDetailedWithList(
                                String.join(", ", di.getDefect().params().getSubset()))))
                .register(MinusPhraseDefectIds.MinusPhrase.INVALID_WORD_FIRST_CHARACTER,
                        paramIntapiDefect(di -> translations.invalidWordFirstCharacterDetailedWithList(
                                String.join(", ", di.getDefect().params().getSubset()))))
                .register(MinusPhraseDefectIds.MinusPhrase.INVALID_EXCLAMATION_MARK,
                        paramIntapiDefect(di -> translations.wrongExclamationMarkInMinusKeywordDetailed(
                                String.join(", ", di.getDefect().params().getSubset()))))
                .register(MinusPhraseDefectIds.MinusPhrase.INVALID_MINUS_MARK,
                        paramIntapiDefect(di -> translations.wrongMinusMarkUsageInMinusKeywordDetailedWithList(
                                String.join(", ", di.getDefect().params().getSubset()))))
                .register(MinusPhraseDefectIds.MinusPhrase.INVALID_OPERATORS_INSIDE_SQUARE_BRACKETS,
                        paramIntapiDefect(di -> translations.notAllowedOperatorsInsideBracketsDetailedWithList(
                                String.join(", ", di.getDefect().params().getSubset()))))
                .register(MinusPhraseDefectIds.MinusPhrase.INVALID_PLUS_MARK,
                        paramIntapiDefect(di -> translations.wrongPlusMarkUsageInMinusKeywordDetailedWithList(
                                String.join(", ", di.getDefect().params().getSubset()))))
                .register(MinusPhraseDefectIds.MinusPhrase.WRONG_QUOTES,
                        paramIntapiDefect(di -> translations.wrongWrappedQuotesInMinusKeywordDetailedWithList(
                                String.join(", ", di.getDefect().params().getSubset()))))
                .register(MinusPhraseDefectIds.MinusPhrase.IMBALANCED_SQUARE_BRACKETS,
                        paramIntapiDefect(di -> translations.imbalancedSquareBracketsDetailedWithList(
                                String.join(", ", di.getDefect().params().getSubset()))))
                .register(MinusPhraseDefectIds.MinusPhrase.NESTED_OR_EMPTY_SQUARE_BRACKETS,
                        paramIntapiDefect(di -> translations.nestedOrEmptySquareBracketsDetailedWithList(
                                String.join(", ", di.getDefect().params().getSubset()))))
                .register(MinusPhraseDefectIds.IndividualKeywordLength.MAX_COUNT_WORDS_IN_KEYWORD,
                        paramIntapiDefect(di -> translations.maxWordsCountInKeywordDetailedWithList(
                                new Identity(di.getDefect().params().getMaxWords()),
                                String.join(", ", di.getDefect().params().getSubset()))))
                .register(MinusPhraseDefectIds.StringLength.MAX_LENGTH_MINUS_KEYWORDS,
                        paramIntapiDefect(di -> translations.maxLengthMinusKeywordsDetailed(
                                new Identity(di.getDefect().params().getMaxLength()))))
                .register(MinusPhraseDefectIds.IndividualKeywordLength.MAX_LENGTH_MINUS_WORD,
                        paramIntapiDefect(di -> translations.maxWordsCountInKeywordDetailedWithList(
                                new Identity(di.getDefect().params().getMaxLength()),
                                String.join(", ", di.getDefect().params().getSubset()))))
                .register(MinusPhraseDefectIds.Gen.MINUS_WORDS_PACK_NOT_FOUND,
                        paramIntapiDefect(di -> translations.minusWordsPackNotFound(
                                new Identity((Long) di.getValue()))))
                .build();
    }
}
