package ru.yandex.direct.intapi.entity.launcher.controller;


import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.direct.intapi.ErrorResponse;
import ru.yandex.direct.intapi.entity.launcher.model.App;
import ru.yandex.direct.intapi.entity.launcher.model.LauncherCampaignsResponse;
import ru.yandex.direct.intapi.entity.launcher.service.LauncherService;
import ru.yandex.direct.tvm.AllowServices;

import static ru.yandex.direct.tvm.TvmService.DIRECT_DEVELOPER;
import static ru.yandex.direct.tvm.TvmService.LAUNCHER_PROD;
import static ru.yandex.direct.tvm.TvmService.LAUNCHER_TEST;

/**
 * Ручки для launcher-a
 * https://wiki.yandex-team.ru/users/aliho/projects/direct/recomendatormobilecamp/#fidsreklamnymikampanijami
 */
@RestController
@RequestMapping("launcher")
@AllowServices(production = {LAUNCHER_PROD}, testing = {LAUNCHER_TEST, DIRECT_DEVELOPER})
@Api(tags = "intapiLauncher")
public class LauncherController {

    public static final Function<App, List<Object>> KEY_EXTRACTOR = app ->
            Arrays.asList(app.getCampaignId(), app.getPackageName(), app.getMinOsVersion(), app.getGeoRestrictions());

    private final LauncherService launcherService;

    @Autowired
    public LauncherController(LauncherService launcherService) {
        this.launcherService = launcherService;
    }

    @ApiOperation(
            value = "intapiLauncherCampaigns",
            httpMethod = "GET",
            nickname = "intapiLauncherCampaigns"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = ErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = LauncherCampaignsResponse.class)
            }
    )
    @RequestMapping(path = "/campaigns",
            method = RequestMethod.GET,
            produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ResponseBody
    public LauncherCampaignsResponse getCampaigns() {
        return launcherService.getLauncherCampaigns();
    }

}
