package ru.yandex.direct.intapi.entity.launcher.model;


import java.math.BigDecimal;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

public class App {
    private String minOsVersion;
    private List<GeoRestriction> geoRestrictions;
    private BigDecimal payout;
    private String packageName;
    private Long capping;
    private String currency;
    private String title;
    private Long bkBannerId;
    private String trackingUrl;
    private Long campaignId;
    private String ageLabel;

    // todo: закомменчено до https://st.yandex-team.ru/DIRECT-76655: [launcher][direct]
    // Добавить дисклеймер для разных языков
    //    private String disclaimer;

    @JsonProperty("min_os_version")
    public String getMinOsVersion() {
        return minOsVersion;
    }

    @ApiModelProperty(notes = "география")
    @JsonProperty("geo_restrictions")
    public List<GeoRestriction> getGeoRestrictions() {
        return geoRestrictions;
    }

    @ApiModelProperty(notes = "цена за установку")
    @JsonProperty("payout")
    public BigDecimal getPayout() {
        return payout;
    }

    @ApiModelProperty(notes = "вместо package_name можно использовать preview_url - ссылку на приложение в google play")
    @JsonProperty("package_name")
    public String getPackageName() {
        return packageName;
    }

    @ApiModelProperty(notes = "максимальное кол-во скачиваний")
    @JsonProperty("capping")
    public Long getCapping() {
        return capping;
    }

    @ApiModelProperty(notes = "трёх-буквенный код валюты в формате ISO 4217", allowableValues = "RUB,EUR,USD")
    @JsonProperty("currency")
    public String getCurrency() {
        return currency;
    }

    @JsonProperty("title")
    public String getTitle() {
        return title;
    }

    @JsonProperty("bk_banner_id")
    public Long getBkBannerId() {
        return bkBannerId;
    }

    @ApiModelProperty(notes = "трекинговая ссылка, по которой вы будет засчитываться установка")
    @JsonProperty("tracking_url")
    public String getTrackingUrl() {
        return trackingUrl;
    }

    @JsonProperty("campaign_id")
    public Long getCampaignId() {
        return campaignId;
    }

    @ApiModelProperty(allowableValues = "0+,6+,12+,16+,18+")
    @JsonProperty("age_label")
    public String getAgeLabel() {
        return ageLabel;
    }

    // todo: закомменчено до https://st.yandex-team.ru/DIRECT-76655: [launcher][direct]
    //  Добавить дисклеймер для разных языков
//    @JsonProperty("disclaimer")
//    public String getDisclaimer() {
//        return disclaimer;
//    }

    public App withMinOsVersion(String minOsVersion) {
        this.minOsVersion = minOsVersion;
        return this;
    }

    public App withPayout(BigDecimal payout) {
        this.payout = payout;
        return this;
    }

    public App withGeoRestrictions(List<GeoRestriction> geoRestrictions) {
        this.geoRestrictions = geoRestrictions;
        return this;
    }

    public App withPackageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public App withCapping(Long capping) {
        this.capping = capping;
        return this;
    }

    public App withCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public App withTitle(String title) {
        this.title = title;
        return this;
    }

    public App withBkBannerId(Long bkBannerId) {
        this.bkBannerId = bkBannerId;
        return this;
    }

    public App withTrackingUrl(String trackingUrl) {
        this.trackingUrl = trackingUrl;
        return this;
    }

    public App withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public App withAgeLabel(String ageLabel) {
        this.ageLabel = ageLabel;
        return this;
    }

    // todo: закомменчено до https://st.yandex-team.ru/DIRECT-76655: [launcher][direct]
    // Добавить дисклеймер для разных языков
//    public App withDisclaimer(String disclaimer) {
//        this.disclaimer = disclaimer;
//        return this;
//    }
}
