package ru.yandex.direct.intapi.entity.launcher.model;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

public class GeoRestriction {
    Long id;
    List<Long> exceptions;

    @ApiModelProperty(notes = "ID региона для нацеливания")
    @JsonProperty("id")
    public Long getId() {
        return id;
    }

    @ApiModelProperty(notes = "ID исключенных подрегионов")
    @JsonProperty("exceptions")
    public List<Long> getExceptions() {
        return exceptions;
    }

    public GeoRestriction withId(Long id) {
        this.id = id;
        return this;
    }

    public GeoRestriction withExceptions(List<Long> exceptions) {
        this.exceptions = exceptions;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GeoRestriction that = (GeoRestriction) o;
        return Objects.equals(id, that.id) &&
                Objects.equals(exceptions, that.exceptions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, exceptions);
    }
}
