package ru.yandex.direct.intapi.entity.metricslog.model;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.monlib.metrics.MetricType;

import static ru.yandex.direct.solomon.SolomonUtils.ENV_LABEL_NAME;

@ApiModel(description = "Описание сенсора")
public class SolomonMetric {
    public static final String LABELS_FIELD_NAME = "labels";
    public static final String NAME_FIELD_NAME = "name";
    public static final String TYPE_FIELD_NAME = "type";
    public static final String LONG_VALUE_FIELD_NAME = "long_value";
    public static final String DOUBLE_VALUE_FIELD_NAME = "double_value";

    @JsonProperty(LABELS_FIELD_NAME)
    @ApiModelProperty(value = "метки", required = true, example = "обязательна метка " + ENV_LABEL_NAME)
    private Map<String, String> labels;

    @JsonProperty(NAME_FIELD_NAME)
    @ApiModelProperty(value = "название сенсора", required = true, example = "reqs.count")
    private String name;

    @JsonProperty(TYPE_FIELD_NAME)
    @ApiModelProperty(value = "тип сенсора", required = true, example = "RATE",
            allowableValues = "RATE")
    private MetricType type;

    @JsonProperty(LONG_VALUE_FIELD_NAME)
    @ApiModelProperty(value = "целочисленное значение", example = "10")
    private Long longValue;

    @JsonProperty(DOUBLE_VALUE_FIELD_NAME)
    @ApiModelProperty(value = "дробное значение", example = "4.2")
    private Double doubleValue;

    public Map<String, String> getLabels() {
        return labels;
    }

    public String getName() {
        return name;
    }

    public MetricType getType() {
        return type;
    }

    public Long getLongValue() {
        return longValue;
    }

    public Double getDoubleValue() {
        return doubleValue;
    }
}
