package ru.yandex.direct.intapi.entity.metrika.model.objectinfo;

import java.time.LocalDateTime;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.metrika.model.objectinfo.AdGroupInfoForMetrika;

public class AdGroupInfo implements MetrikaObjectInfo {

    @JsonProperty("ad_group_id")
    private Long adGroupId;

    @JsonProperty("order_id")
    private Long orderId;

    @JsonProperty("group_name")
    private String name;

    @JsonProperty("last_change")
    private String lastChange;

    @JsonIgnore
    private LocalDateTime lastChangeSource;

    public AdGroupInfo(Long adGroupId, Long orderId, String name, LocalDateTime lastChange) {
        this.adGroupId = adGroupId;
        this.orderId = orderId;
        this.name = name;
        this.lastChange = lastChange.format(MetrikaTimeToken.DATE_TIME_FORMATTER);
        this.lastChangeSource = lastChange;
    }

    public static AdGroupInfo fromCoreModel(AdGroupInfoForMetrika adGroupInfoForMetrika) {
        return new AdGroupInfo(adGroupInfoForMetrika.getId(),
                adGroupInfoForMetrika.getOrderId(),
                adGroupInfoForMetrika.getName(),
                adGroupInfoForMetrika.getLastChange());
    }

    @Override
    @JsonIgnore
    public Long getSortId() {
        return adGroupId;
    }

    @Override
    @JsonIgnore
    public LocalDateTime getSortLastChange() {
        return lastChangeSource;
    }
}
