package ru.yandex.direct.intapi.entity.metrika.model.objectinfo;

import java.time.LocalDateTime;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.metrika.model.objectinfo.BannerInfoForMetrika;

/**
 * Представление баннера, включая картиночные,
 * поэтому сортировка производится по LC + (микс из bid и banner_image).
 */
@ParametersAreNonnullByDefault
public class BannerInfo implements MetrikaObjectInfo {

    @JsonIgnore
    private Long sortId;

    @JsonProperty("bid")
    private Long bannerId;

    @JsonProperty("bs_banner_id")
    private Long bsBannerId;

    @JsonProperty("title")
    private String title;

    @JsonProperty("body")
    private String body;

    @JsonProperty("last_change")
    private String lastChange;

    @JsonIgnore
    private LocalDateTime lastChangeSource;

    public BannerInfo(Long sortId, Long bannerId, Long bsBannerId, String title, String body,
                      LocalDateTime lastChange) {
        this.sortId = sortId;
        this.bannerId = bannerId;
        this.bsBannerId = bsBannerId;
        this.title = title;
        this.body = body;
        this.lastChange = lastChange.format(MetrikaTimeToken.DATE_TIME_FORMATTER);
        this.lastChangeSource = lastChange;
    }

    public static BannerInfo fromCoreModel(BannerInfoForMetrika bannerInfoForMetrika) {
        return new BannerInfo(bannerInfoForMetrika.getSortId(),
                bannerInfoForMetrika.getBannerId(),
                bannerInfoForMetrika.getBsBannerId(),
                bannerInfoForMetrika.getTitle(),
                bannerInfoForMetrika.getBody(),
                bannerInfoForMetrika.getLastChange());
    }

    @Override
    @JsonIgnore
    public Long getSortId() {
        return sortId;
    }

    @Override
    @JsonIgnore
    public LocalDateTime getSortLastChange() {
        return lastChangeSource;
    }
}
