package ru.yandex.direct.intapi.entity.metrika.model.objectinfo;

import java.time.LocalDateTime;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.metrika.model.objectinfo.CampaignInfoForMetrika;

@ParametersAreNonnullByDefault
public class CampaignInfo implements MetrikaObjectInfo {

    @JsonProperty("cid")
    private Long id;

    @JsonProperty("order_id")
    private Long orderId;

    @JsonProperty("client_id")
    private Long clientId;

    @JsonProperty("uid")
    private Long uid;

    @JsonProperty("name")
    private String name;

    @JsonProperty("all_reps")
    private List<Long> reps;

    @JsonProperty("last_change")
    private String lastChange;

    @JsonIgnore
    private LocalDateTime lastChangeSource;

    public CampaignInfo(Long id, Long orderId, Long clientId, Long uid, String name, List<Long> reps,
                        LocalDateTime lastChange) {
        this.id = id;
        this.orderId = orderId;
        this.clientId = clientId;
        this.uid = uid;
        this.name = name;
        this.reps = reps;
        this.lastChange = lastChange.format(MetrikaTimeToken.DATE_TIME_FORMATTER);
        this.lastChangeSource = lastChange;
    }

    public static CampaignInfo fromCoreModel(CampaignInfoForMetrika campInfo) {
        return new CampaignInfo(campInfo.getId(),
                campInfo.getOrderId(),
                campInfo.getClientId(),
                campInfo.getUid(),
                campInfo.getName(),
                campInfo.getReps(),
                campInfo.getLastChange());
    }

    @Override
    @JsonIgnore
    public Long getSortId() {
        return id;
    }

    @Override
    @JsonIgnore
    public LocalDateTime getSortLastChange() {
        return lastChangeSource;
    }
}
