package ru.yandex.direct.intapi.entity.metrika.model.objectinfo;

import java.time.LocalDateTime;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.metrika.model.objectinfo.CreativeInfoForMetrika;

import static org.apache.commons.lang3.StringUtils.isEmpty;

public class CreativeInfo implements MetrikaObjectInfo {
    private static final String CREATIVE_ID_FIELD = "creative_id";
    private static final String ORDER_ID_FIELD = "order_id";
    private static final String NAME_FIELD = "name";
    private static final String LAST_CHANGE_FIELD = "last_change";

    @JsonProperty(CREATIVE_ID_FIELD)
    private Long creativeId;

    @JsonProperty(ORDER_ID_FIELD)
    private Long orderId;

    @JsonProperty(NAME_FIELD)
    private String name;

    @JsonProperty(LAST_CHANGE_FIELD)
    private String lastChange;

    @JsonIgnore
    private LocalDateTime lastChangeSource;

    @JsonCreator
    public CreativeInfo(@JsonProperty(CREATIVE_ID_FIELD) Long creativeId,
                        @JsonProperty(ORDER_ID_FIELD) Long orderId,
                        @JsonProperty(NAME_FIELD) String name,
                        @JsonProperty(LAST_CHANGE_FIELD) LocalDateTime lastChange) {
        this.creativeId = creativeId;
        this.orderId = orderId;
        this.name = name;
        this.lastChange = lastChange.format(MetrikaTimeToken.DATE_TIME_FORMATTER);
        this.lastChangeSource = lastChange;
    }

    public static CreativeInfo fromCoreModel(CreativeInfoForMetrika creativeInfoForMetrika) {
        String name = !isEmpty(creativeInfoForMetrika.getName()) ?
                creativeInfoForMetrika.getName() :
                creativeInfoForMetrika.getGroupName();
        if (name == null) {
            name = "";
        }
        return new CreativeInfo(creativeInfoForMetrika.getId(),
                creativeInfoForMetrika.getOrderId(),
                name,
                creativeInfoForMetrika.getModerateSendTime());
    }

    @Override
    @JsonIgnore
    public Long getSortId() {
        return creativeId;
    }

    @Override
    @JsonIgnore
    public LocalDateTime getSortLastChange() {
        return lastChangeSource;
    }

}
