package ru.yandex.direct.intapi.entity.metrika.model.objectinfo;

import java.time.LocalDateTime;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.metrika.model.objectinfo.PerformanceFilterInfoForMetrika;

public class PerformanceFilterInfo implements MetrikaObjectInfo {

    @JsonProperty("perf_filter_id")
    private Long perfFilterId;

    @JsonProperty("order_id")
    private Long orderId;

    @JsonProperty("name")
    private String name;

    @JsonProperty("last_change")
    private String lastChange;

    @JsonIgnore
    private LocalDateTime lastChangeSource;

    @JsonCreator
    public PerformanceFilterInfo(@JsonProperty("perf_filter_id") Long perfFilterId,
                                 @JsonProperty("order_id") Long orderId,
                                 @JsonProperty("name") String name,
                                 @JsonProperty("last_change") LocalDateTime lastChange) {
        this.perfFilterId = perfFilterId;
        this.orderId = orderId;
        this.name = name;
        this.lastChange = lastChange.format(MetrikaTimeToken.DATE_TIME_FORMATTER);
        this.lastChangeSource = lastChange;
    }

    public static PerformanceFilterInfo fromCoreModel(PerformanceFilterInfoForMetrika perfFilterInfoForMetrika) {
        return new PerformanceFilterInfo(perfFilterInfoForMetrika.getId(),
                perfFilterInfoForMetrika.getOrderId(),
                perfFilterInfoForMetrika.getName(),
                perfFilterInfoForMetrika.getLastChange());
    }

    @Override
    @JsonIgnore
    public Long getSortId() {
        return perfFilterId;
    }

    @Override
    @JsonIgnore
    public LocalDateTime getSortLastChange() {
        return lastChangeSource;
    }

    @JsonIgnore
    public Long getOrderId() {
        return orderId;
    }

    @JsonIgnore
    public String getName() {
        return name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PerformanceFilterInfo that = (PerformanceFilterInfo) o;
        return Objects.equals(perfFilterId, that.perfFilterId) &&
                Objects.equals(orderId, that.orderId) &&
                Objects.equals(name, that.name) &&
                Objects.equals(lastChange, that.lastChange);
    }

    @Override
    public int hashCode() {
        return Objects.hash(perfFilterId, orderId, name, lastChange);
    }
}
