package ru.yandex.direct.intapi.entity.metrika.model.objectinfo;

import java.time.LocalDateTime;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.metrika.model.objectinfo.RetargetingConditionInfoForMetrika;

@ParametersAreNonnullByDefault
public class RetargetingConditionInfo implements MetrikaObjectInfo {

    @JsonProperty("ret_cond_id")
    private Long id;

    @JsonProperty("condition_name")
    private String name;

    @JsonProperty("condition_desc")
    private String description;

    @JsonProperty("last_change")
    private String lastChange;

    @JsonIgnore
    private LocalDateTime lastChangeSource;

    public RetargetingConditionInfo(Long id, String name, String description, LocalDateTime lastChange) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.lastChange = lastChange.format(MetrikaTimeToken.DATE_TIME_FORMATTER);
        this.lastChangeSource = lastChange;
    }

    public static RetargetingConditionInfo fromCoreModel(
            RetargetingConditionInfoForMetrika retargetingCondition) {
        return new RetargetingConditionInfo(
                retargetingCondition.getId(),
                retargetingCondition.getName(),
                retargetingCondition.getDescription(),
                retargetingCondition.getLastChange());
    }

    @Override
    @JsonIgnore
    public Long getSortId() {
        return id;
    }

    @Override
    @JsonIgnore
    public LocalDateTime getSortLastChange() {
        return lastChangeSource;
    }
}
