package ru.yandex.direct.intapi.entity.metrika.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.IdModFilter;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingConditionService;
import ru.yandex.direct.intapi.validation.IntApiDefect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.intapi.validation.ValidationUtils.checkResult;

@Service
public class MetrikaRetargetingGoalsService {

    @Autowired
    private RetargetingConditionService retargetingConditionService;

    @Autowired
    private ModFilterValidationService modFilterValidationService;

    public List<Long> getGoals(long divisor, long reminder) {
        IdModFilter filter = new IdModFilter(divisor, reminder);

        ValidationResult<IdModFilter, IntApiDefect> validationResult = modFilterValidationService.validate(filter);
        checkResult(validationResult);

        return retargetingConditionService.getAccessibleGoalIdsForAllShards(filter);
    }
}
