package ru.yandex.direct.intapi.entity.metrika.service.objectinfo;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.metrika.model.objectinfo.AdGroupInfoForMetrika;
import ru.yandex.direct.core.entity.metrika.repository.MetrikaAdGroupRepository;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.intapi.entity.metrika.model.objectinfo.AdGroupInfo;
import ru.yandex.direct.intapi.entity.metrika.model.objectinfo.MetrikaTimeToken;

import static ru.yandex.direct.multitype.entity.LimitOffset.limited;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Service
@ParametersAreNonnullByDefault
public class MetrikaAdGroupInfoServiceDelegate implements MetrikaObjectInfoServiceDelegate<AdGroupInfo> {

    @Autowired
    private MetrikaAdGroupRepository metrikaAdGroupRepository;

    @Autowired
    private ShardHelper shardHelper;

    @Override
    public List<AdGroupInfo> obtainFromRepo(@Nullable MetrikaTimeToken timeToken, @Nullable Integer limit) {
        List<AdGroupInfoForMetrika> coreModels = new ArrayList<>();
        if (timeToken != null) {
            shardHelper.forEachShard(shard -> coreModels.addAll(
                    metrikaAdGroupRepository.getAdGroupsInfo(shard, timeToken.getLastChange(), timeToken.getLastId(),
                            (limit != null ? limited(limit) : null))));
        } else {
            shardHelper.forEachShard(shard -> coreModels.addAll(
                    metrikaAdGroupRepository.getAdGroupsInfo(shard, (limit != null ? limited(limit) : null))));
        }
        return mapList(coreModels, AdGroupInfo::fromCoreModel);
    }
}
