package ru.yandex.direct.intapi.entity.metrika.service.objectinfo;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.metrika.model.objectinfo.BannerInfoForMetrika;
import ru.yandex.direct.core.entity.metrika.repository.MetrikaBannerRepository;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.intapi.entity.metrika.model.objectinfo.BannerInfo;
import ru.yandex.direct.intapi.entity.metrika.model.objectinfo.MetrikaTimeToken;

import static ru.yandex.direct.multitype.entity.LimitOffset.limited;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Service
@ParametersAreNonnullByDefault
public class MetrikaBannerInfoServiceDelegate implements MetrikaObjectInfoServiceDelegate<BannerInfo> {

    @Autowired
    private MetrikaBannerRepository metrikaBannerRepository;

    @Autowired
    private ShardHelper shardHelper;

    @Override
    public List<BannerInfo> obtainFromRepo(@Nullable MetrikaTimeToken timeToken, @Nullable Integer limit) {
        List<BannerInfoForMetrika> coreModels = new ArrayList<>();
        if (timeToken != null) {
            shardHelper.forEachShard(shard -> coreModels.addAll(
                    metrikaBannerRepository.getBannersInfo(shard, timeToken.getLastChange(), timeToken.getLastId(),
                            (limit != null ? limited(limit) : null))));
        } else {
            shardHelper.forEachShard(shard -> coreModels.addAll(
                    metrikaBannerRepository.getBannersInfo(shard, (limit != null ? limited(limit) : null))));
        }
        return mapList(coreModels, BannerInfo::fromCoreModel);
    }
}
