package ru.yandex.direct.intapi.entity.metrika.service.objectinfo;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.metrika.model.objectinfo.CreativeInfoForMetrika;
import ru.yandex.direct.core.entity.metrika.repository.MetrikaCreativeRepository;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.intapi.entity.metrika.model.objectinfo.CreativeInfo;
import ru.yandex.direct.intapi.entity.metrika.model.objectinfo.MetrikaTimeToken;

import static ru.yandex.direct.multitype.entity.LimitOffset.limited;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Service
@ParametersAreNonnullByDefault
public class MetrikaCreativeInfoServiceDelegate
        implements MetrikaObjectInfoServiceDelegate<CreativeInfo> {

    @Autowired
    private MetrikaCreativeRepository metrikaCreativeRepository;

    @Autowired
    private ShardHelper shardHelper;

    @Override
    public List<CreativeInfo> obtainFromRepo(@Nullable MetrikaTimeToken timeToken, @Nullable Integer limit) {
        List<CreativeInfoForMetrika> coreModels = new ArrayList<>();
        if (timeToken != null) {
            shardHelper.forEachShard(shard -> coreModels.addAll(
                    metrikaCreativeRepository.getCreativesInfo(shard, timeToken.getLastChange(),
                            timeToken.getLastId(), (limit != null ? limited(limit) : null))));
        } else {
            shardHelper.forEachShard(shard -> coreModels.addAll(
                    metrikaCreativeRepository
                            .getCreativesInfo(shard, (limit != null ? limited(limit) : null))));
        }
        return mapList(coreModels, CreativeInfo::fromCoreModel);
    }
}
