package ru.yandex.direct.intapi.entity.metrika.service.objectinfo;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Service;

import ru.yandex.direct.intapi.entity.metrika.model.objectinfo.MetrikaObjectInfo;
import ru.yandex.direct.intapi.entity.metrika.model.objectinfo.MetrikaObjectInfoRequest;
import ru.yandex.direct.intapi.entity.metrika.model.objectinfo.MetrikaObjectInfoResponse;
import ru.yandex.direct.intapi.entity.metrika.model.objectinfo.MetrikaTimeToken;

import static ru.yandex.direct.intapi.entity.metrika.service.objectinfo.validation.MetrikaObjectInfoRequestValidator.validateObjectInfoRequest;
import static ru.yandex.direct.intapi.validation.ValidationUtils.checkResult;

@Service
@ParametersAreNonnullByDefault
public class MetrikaObjectInfoService {

    public <T extends MetrikaObjectInfo> MetrikaObjectInfoResponse<T> getObjectsInfo(
            MetrikaObjectInfoRequest request, MetrikaObjectInfoServiceDelegate<T> delegate) {
        checkResult(validateObjectInfoRequest(request));

        MetrikaTimeToken timeToken = request.getTimeToken() != null ?
                new MetrikaTimeToken(request.getTimeToken()) :
                null;

        List<T> objectsInfo = delegate.obtainFromRepo(timeToken, request.getLimit());
        return MetrikaObjectInfoResponse.create(objectsInfo, request.getLimit(), timeToken);
    }
}
