package ru.yandex.direct.intapi.entity.metrika.service.objectinfo;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.metrika.model.objectinfo.PerformanceFilterInfoForMetrika;
import ru.yandex.direct.core.entity.metrika.repository.MetrikaPerformanceFilterRepository;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.intapi.entity.metrika.model.objectinfo.MetrikaTimeToken;
import ru.yandex.direct.intapi.entity.metrika.model.objectinfo.PerformanceFilterInfo;

import static ru.yandex.direct.multitype.entity.LimitOffset.limited;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Service
@ParametersAreNonnullByDefault
public class MetrikaPerformanceFilterInfoServiceDelegate
        implements MetrikaObjectInfoServiceDelegate<PerformanceFilterInfo> {

    @Autowired
    private MetrikaPerformanceFilterRepository metrikaPerformanceFiltersRepository;

    @Autowired
    private ShardHelper shardHelper;

    @Override
    public List<PerformanceFilterInfo> obtainFromRepo(@Nullable MetrikaTimeToken timeToken, @Nullable Integer limit) {
        List<PerformanceFilterInfoForMetrika> coreModels = new ArrayList<>();
        if (timeToken != null) {
            shardHelper.forEachShard(shard -> coreModels.addAll(
                    metrikaPerformanceFiltersRepository
                            .getFiltersInfo(shard, timeToken.getLastChange(), timeToken.getLastId(),
                                    (limit != null ? limited(limit) : null))));
        } else {
            shardHelper.forEachShard(shard -> coreModels.addAll(
                    metrikaPerformanceFiltersRepository
                            .getFiltersInfo(shard, (limit != null ? limited(limit) : null))));
        }
        return mapList(coreModels, PerformanceFilterInfo::fromCoreModel);
    }
}
