package ru.yandex.direct.intapi.entity.metrika.service.objectinfo;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.metrika.model.objectinfo.RetargetingConditionInfoForMetrika;
import ru.yandex.direct.core.entity.metrika.repository.MetrikaRetargetingConditionRepository;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.intapi.entity.metrika.model.objectinfo.MetrikaTimeToken;
import ru.yandex.direct.intapi.entity.metrika.model.objectinfo.RetargetingConditionInfo;

import static ru.yandex.direct.multitype.entity.LimitOffset.limited;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Service
@ParametersAreNonnullByDefault
public class MetrikaRetargetingConditionInfoServiceDelegate
        implements MetrikaObjectInfoServiceDelegate<RetargetingConditionInfo> {

    @Autowired
    private MetrikaRetargetingConditionRepository retargetingConditionRepository;

    @Autowired
    private ShardHelper shardHelper;

    @Override
    public List<RetargetingConditionInfo> obtainFromRepo(@Nullable MetrikaTimeToken timeToken,
                                                         @Nullable Integer limit) {
        List<RetargetingConditionInfoForMetrika> coreModels = new ArrayList<>();
        if (timeToken != null) {
            shardHelper.forEachShard(shard -> coreModels.addAll(
                    retargetingConditionRepository.getRetargetingConditionsInfo(shard, timeToken.getLastChange(),
                            timeToken.getLastId(), (limit != null ? limited(limit) : null))));
        } else {
            shardHelper.forEachShard(shard -> coreModels.addAll(
                    retargetingConditionRepository
                            .getRetargetingConditionsInfo(shard, (limit != null ? limited(limit) : null))));
        }
        return mapList(coreModels, RetargetingConditionInfo::fromCoreModel);
    }
}
