package ru.yandex.direct.intapi.entity.metrika.service.objectinfo.validation;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.intapi.entity.metrika.model.objectinfo.MetrikaObjectInfoRequest;
import ru.yandex.direct.intapi.validation.IntApiDefect;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.intapi.entity.metrika.service.objectinfo.validation.MetrikaTimeTokenConstraint.validTimeToken;
import static ru.yandex.direct.intapi.validation.IntApiConstraints.greaterThan;

@ParametersAreNonnullByDefault
public class MetrikaObjectInfoRequestValidator implements Validator<MetrikaObjectInfoRequest, IntApiDefect> {

    private static final MetrikaObjectInfoRequestValidator INSTANCE =
            new MetrikaObjectInfoRequestValidator();

    public static ValidationResult<MetrikaObjectInfoRequest, IntApiDefect> validateObjectInfoRequest(
            MetrikaObjectInfoRequest request) {
        return INSTANCE.apply(request);
    }

    @Override
    public ValidationResult<MetrikaObjectInfoRequest, IntApiDefect> apply(
            MetrikaObjectInfoRequest request) {
        ItemValidationBuilder<MetrikaObjectInfoRequest, IntApiDefect> vb =
                ItemValidationBuilder.of(request, IntApiDefect.class);

        vb.item(request.getTimeToken(), "timeToken").check(validTimeToken());

        vb.item(request.getLimit(), "limit").check(greaterThan(0));

        return vb.getResult();
    }
}
