package ru.yandex.direct.intapi.entity.mobilecontent.controller;

import java.util.List;
import java.util.Map;

import javax.ws.rs.core.MediaType;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import one.util.streamex.StreamEx;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import ru.yandex.direct.intapi.ErrorResponse;
import ru.yandex.direct.intapi.entity.mobilecontent.model.ApiMobileContentRequest;
import ru.yandex.direct.intapi.entity.mobilecontent.model.ApiMobileContentResponse;
import ru.yandex.direct.tvm.AllowServices;
import ru.yandex.direct.web.core.entity.mobilecontent.service.WebCoreMobileAppService;
import ru.yandex.direct.web.core.model.WebErrorResponse;
import ru.yandex.direct.web.core.model.WebResponse;

import static ru.yandex.direct.tvm.TvmService.ADFOX_LOGIN;
import static ru.yandex.direct.tvm.TvmService.ADFOX_LOGIN_TEST;
import static ru.yandex.direct.tvm.TvmService.DIRECT_DEVELOPER;

@Controller
@RequestMapping(value = "/mobile_app_api", produces = MediaType.APPLICATION_JSON)
@Api(tags = "mobile_app_api")
@AllowServices(production = {ADFOX_LOGIN}, testing = {ADFOX_LOGIN_TEST, DIRECT_DEVELOPER})
public class MobileAppApiController {
    static final int MAX_API_MOBILE_CONTENT_ITEMS = 10000;

    private final WebCoreMobileAppService webCoreMobileAppService;

    public MobileAppApiController(WebCoreMobileAppService webCoreMobileAppService) {
        this.webCoreMobileAppService = webCoreMobileAppService;
    }

    @ApiOperation(
            value = "list",
            nickname = "list",
            httpMethod = "POST"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 200, message = "Ok", response = ApiMobileContentResponse.class),
                    @ApiResponse(code = 400, message = "Bad params", response = ErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = ErrorResponse.class),
                    @ApiResponse(code = 500, message = "Internal Server Error", response = WebErrorResponse.class)
            }
    )
    @RequestMapping(path = "/list", method = RequestMethod.POST)
    @ResponseBody
    public WebResponse list(@RequestBody ApiMobileContentRequest request) {
        var apps = request.getApps();
        if (apps.size() > MAX_API_MOBILE_CONTENT_ITEMS) {
            return new WebErrorResponse(500, "Number of requested appIds exceeds " + MAX_API_MOBILE_CONTENT_ITEMS);
        }

        Map<String, List<String>> storeToIds = StreamEx.of(apps)
                .mapToEntry(ApiMobileContentRequest.App::getStore, ApiMobileContentRequest.App::getAppId)
                .grouping();
        try {
            var mobileContentList = webCoreMobileAppService.listApiMobileContent(storeToIds);
            return new ApiMobileContentResponse(mobileContentList);
        } catch (IllegalArgumentException e) {
            return new WebErrorResponse(500, e.getMessage());
        }
    }
}
