package ru.yandex.direct.intapi.entity.mobilecontent.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class ApiMobileContentRequest {
    public static class App {
        private final String store;

        @JsonProperty("app_id")
        private final String appId;

        @JsonCreator
        public App(@JsonProperty("store") String store, @JsonProperty("app_id") String appId) {
            this.store = store;
            this.appId = appId;
        }

        public String getStore() {
            return store;
        }

        public String getAppId() {
            return appId;
        }
    }

    private final List<App> apps;

    @JsonCreator
    public ApiMobileContentRequest(@JsonProperty("apps") List<App> apps) {
        this.apps = apps;
    }

    public List<App> getApps() {
        return apps;
    }
}
