package ru.yandex.direct.intapi.entity.mobilecontent.model;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.dbutil.model.ClientId;

@ParametersAreNonnullByDefault
public class CreateMobileAppRequest {
    public static class Entity {
        private final String storeHref;

        @Nullable
        private final String minimalOperatingSystemVersion;

        @Nullable
        private final String trackerUrl;

        @Nullable
        private final String impressionUrl;

        @JsonCreator
        public Entity(@JsonProperty("storeHref") String storeHref,
                      @JsonProperty("minimalOperatingSystemVersion") @Nullable String minimalOperatingSystemVersion,
                      @JsonProperty("trackerUrl") @Nullable String trackerUrl,
                      @JsonProperty("impressionUrl") @Nullable String impressionUrl) {
            this.storeHref = storeHref;
            this.minimalOperatingSystemVersion = minimalOperatingSystemVersion;
            this.trackerUrl = trackerUrl;
            this.impressionUrl = impressionUrl;
        }

        public String getStoreHref() {
            return storeHref;
        }

        @Nullable
        public String getMinimalOperatingSystemVersion() {
            return minimalOperatingSystemVersion;
        }

        @Nullable
        public String getTrackerUrl() {
            return trackerUrl;
        }

        @Nullable
        public String getImpressionUrl() {
            return impressionUrl;
        }
    }

    private final ClientId clientId;
    private final List<Entity> entities;

    public CreateMobileAppRequest(ClientId clientId, List<Entity> entities) {
        this.clientId = clientId;
        this.entities = entities;
    }

    @JsonCreator
    public CreateMobileAppRequest(@JsonProperty("clientId") Long clientId,
                                  @JsonProperty("entities") List<Entity> entities) {
        this.clientId = ClientId.fromLong(clientId);
        this.entities = entities;
    }

    public ClientId getClientId() {
        return clientId;
    }

    public List<Entity> getEntities() {
        return entities;
    }
}
