package ru.yandex.direct.intapi.entity.mobilecontent.model;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.web.core.model.WebSuccessResponse;

@ParametersAreNonnullByDefault
public class CreateMobileAppResponse extends WebSuccessResponse {
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public static class Entry {
        private final boolean success;

        @Nullable
        private final ErrorType error;

        @Nullable
        private final Long mobileAppId;

        @SuppressWarnings("WeakerAccess")
        @JsonCreator
        public Entry(@JsonProperty("success") boolean success,
                     @JsonProperty("error") @Nullable ErrorType error,
                     @JsonProperty("mobileAppId") @Nullable Long mobileAppId) {
            this.success = success;
            this.error = error;
            this.mobileAppId = mobileAppId;
        }

        public static Entry success(Long mobileAppId) {
            return new Entry(true, null, mobileAppId);
        }

        public static Entry error(ErrorType error) {
            return new Entry(false, error, null);
        }

        public boolean isSuccess() {
            return success;
        }

        @Nullable
        public ErrorType getError() {
            return error;
        }

        @Nullable
        public Long getMobileAppId() {
            return mobileAppId;
        }
    }

    public enum ErrorType {
        INVALID_STORE_HREF,
        INVALID_TRACKER_URL;
    }

    private final List<Entry> result;

    @JsonCreator
    public CreateMobileAppResponse(@JsonProperty("result") List<Entry> result) {
        this.result = result;
    }

    public List<Entry> getResult() {
        return result;
    }
}
