package ru.yandex.direct.intapi.entity.mobilecontent.presentation;

import ru.yandex.direct.intapi.validation.kernel.TranslatableIntapiDefect;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;

import static ru.yandex.direct.core.entity.mobileapp.MobileAppDefects.Gen.APPMETRIKA_APPLICATION_ALREADY_USED;
import static ru.yandex.direct.core.entity.mobileapp.MobileAppDefects.Gen.APP_NOT_FOUND;
import static ru.yandex.direct.core.entity.mobileapp.MobileAppDefects.Gen.CAN_NOT_CHANGE_TRACKING_SYSTEM_IN_CPI_CAMPAIGN;
import static ru.yandex.direct.core.entity.mobileapp.MobileAppDefects.Gen.CAN_NOT_CHANGE_TRACKING_SYSTEM_WITH_UNTRACKABLE_BANNER_HREF;
import static ru.yandex.direct.core.entity.mobileapp.MobileAppDefects.Gen.CAN_NOT_REMOVE_TRACKING_URL_IN_CPI_CAMPAIGN;
import static ru.yandex.direct.core.entity.mobileapp.MobileAppDefects.Gen.INVALID_APP_STORE_URL;
import static ru.yandex.direct.core.entity.mobileapp.MobileAppDefects.Gen.INVALID_DOMAIN;
import static ru.yandex.direct.core.entity.mobileapp.MobileAppDefects.Gen.INVALID_URL;
import static ru.yandex.direct.core.entity.mobileapp.MobileAppDefects.Gen.NO_ACCESS_TO_CHANGE_DOMAIN;
import static ru.yandex.direct.core.entity.mobileapp.MobileAppDefects.Gen.PROPAGATION_IS_FAILED;
import static ru.yandex.direct.core.entity.mobileapp.MobileAppDefects.Gen.TOO_MANY_BANNERS;
import static ru.yandex.direct.core.entity.mobileapp.MobileAppDefects.Gen.TRACKER_URL_DOMAIN_DOES_NOT_MATCH_SELECTED_TRACKER_SYSTEM;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.defaultIntapiDefect;

public class MobileAppDefectPresentations {

    private MobileAppDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableIntapiDefect> mobileAppDefectPresentationRegistry() {
        return DefaultDefectPresentationRegistry.builder()
                .register(NO_ACCESS_TO_CHANGE_DOMAIN, defaultIntapiDefect())
                .register(INVALID_URL, defaultIntapiDefect())
                .register(INVALID_APP_STORE_URL, defaultIntapiDefect())
                .register(INVALID_DOMAIN, defaultIntapiDefect())
                .register(TRACKER_URL_DOMAIN_DOES_NOT_MATCH_SELECTED_TRACKER_SYSTEM, defaultIntapiDefect())
                .register(APP_NOT_FOUND, defaultIntapiDefect())
                .register(TOO_MANY_BANNERS, defaultIntapiDefect())
                .register(PROPAGATION_IS_FAILED, defaultIntapiDefect())
                .register(CAN_NOT_REMOVE_TRACKING_URL_IN_CPI_CAMPAIGN, defaultIntapiDefect())
                .register(CAN_NOT_CHANGE_TRACKING_SYSTEM_IN_CPI_CAMPAIGN, defaultIntapiDefect())
                .register(CAN_NOT_CHANGE_TRACKING_SYSTEM_WITH_UNTRACKABLE_BANNER_HREF, defaultIntapiDefect())
                .register(APPMETRIKA_APPLICATION_ALREADY_USED, defaultIntapiDefect())
                .build();
    }
}
