package ru.yandex.direct.intapi.entity.moderation.model;

import java.util.Objects;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class BlockClientResult {

    @JsonProperty("client_id")
    protected Long clientId;

    @JsonProperty("previous_block_status")
    protected ClientBlockStatus previousBlockStatus;

    @JsonProperty("error")
    protected String error;

    public BlockClientResult() {
    }

    public BlockClientResult(@Nonnull Long clientId,
                             @Nullable ClientBlockStatus previousBlockStatus,
                             @Nullable String error) {
        this.clientId = clientId;
        this.previousBlockStatus = previousBlockStatus;
        this.error = error;
    }

    public BlockClientResult(@Nonnull Long clientId, ClientBlockStatus previousBlockStatus) {
        this(clientId, previousBlockStatus, null);
    }

    public BlockClientResult(@Nonnull Long clientId, String error) {
        this(clientId, null, error);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BlockClientResult that = (BlockClientResult) o;
        return Objects.equals(clientId, that.clientId) &&
                Objects.equals(previousBlockStatus, that.previousBlockStatus);
    }

    @Override
    public int hashCode() {
        return Objects.hash(clientId, previousBlockStatus);
    }

    @Override
    public String toString() {
        return "BlockClientResult{" +
                "clientId=" + clientId +
                ", previousBlockStatus=" + previousBlockStatus +
                '}';
    }
}

